/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts;

import java.io.IOException;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.truetype.TrueTypeFontRegistry;

public class FontTypeTest {
    private FontTypeTest() {
    }

    public static void main(String[] args) throws IOException {
        TrueTypeFontRegistry registry = new TrueTypeFontRegistry();
        registry.initialize();
        String[] fontFamilies = registry.getRegisteredFamilies();
        int i = 0;
        while (i < fontFamilies.length) {
            String fontFamily = fontFamilies[i];
            System.out.println("FontFamily: " + fontFamily);
            FontFamily family = registry.getFontFamily(fontFamily);
            FontTypeTest.printRecord(family.getFontRecord(false, false));
            FontTypeTest.printRecord(family.getFontRecord(true, false));
            FontTypeTest.printRecord(family.getFontRecord(false, true));
            FontTypeTest.printRecord(family.getFontRecord(true, true));
            ++i;
        }
        String[] allFontFamilies = registry.getAllRegisteredFamilies();
        int i2 = 0;
        while (i2 < allFontFamilies.length) {
            String family = allFontFamilies[i2];
            System.out.println("I18n: FontFamily: " + family);
            ++i2;
        }
        System.out.println(registry.getFontFamily("Skolle"));
        System.out.println(registry.getFontFamily("Tahoma2"));
    }

    private static void printRecord(FontRecord record) {
        if (record == null) {
            System.out.println("  -");
        } else if (record.isItalic() || record.isOblique()) {
            System.out.println("  " + record.getName() + " it:" + record.isItalic() + " ob:" + record.isOblique());
        }
    }
}

