/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class FunctionTablePanel
extends Panel {
    private String[] all_variable_names;
    private String[][] all_variable_values;
    private double[] table_values;
    private int[] parents_current_choices;
    private Panel ap;
    private Panel dp;
    private Panel pp;
    private Label parents_announce;
    private Label[] parents_labels;
    private Label separator_label;
    private Choice[] parent_choices;
    private TextField[][] fields;
    private Label first_parent_name_label;
    private Label[] first_parent_values_labels;
    private Label[] node_values_labels;
    private static final Color color_parents = Color.red;
    private static final String parents_announce_label = "Values for parents:";

    public FunctionTablePanel(String[] avn, String[][] avv, double[] tv) {
        this.all_variable_names = avn;
        this.all_variable_values = avv;
        this.table_values = tv;
        this.build_panels();
        if (this.all_variable_names.length > 2) {
            this.parents_current_choices = new int[this.parent_choices.length];
            for (int i = 0; i < this.parents_current_choices.length; ++i) {
                this.parents_current_choices[i] = this.parent_choices[i].getSelectedIndex();
            }
        }
        this.setLayout(new BorderLayout());
        this.add("North", this.ap);
        this.add("Center", this.dp);
    }

    public double[] get_table() {
        this.update_table_values();
        return this.table_values;
    }

    public void insert_table(double[] new_table) {
        this.table_values = new_table;
        if (this.all_variable_names.length == 1) {
            for (int j = 0; j < this.all_variable_values[0].length; ++j) {
                this.fields[j][0].setText(String.valueOf(this.table_values[j]));
            }
        } else if (this.all_variable_names.length == 2) {
            for (int i = 0; i < this.all_variable_values[0].length; ++i) {
                for (int j = 0; j < this.all_variable_values[1].length; ++j) {
                    this.fields[i][j].setText(String.valueOf(this.table_values[i * this.all_variable_values[1].length + j]));
                }
            }
        } else {
            int k;
            double value_set = 0.0;
            int[] parent_indexes = new int[this.all_variable_names.length];
            for (k = 0; k < this.parent_choices.length; ++k) {
                parent_indexes[k + 2] = this.parent_choices[k].getSelectedIndex();
            }
            for (int i = 0; i < this.all_variable_values[0].length; ++i) {
                for (int j = 0; j < this.all_variable_values[1].length; ++j) {
                    parent_indexes[0] = i;
                    parent_indexes[1] = j;
                    this.fields[i][j].setText(String.valueOf(this.table_values[this.get_location_from_indexes(parent_indexes)]));
                }
            }
            for (k = 0; k < this.parents_current_choices.length; ++k) {
                this.parents_current_choices[k] = this.parent_choices[k].getSelectedIndex();
            }
        }
    }

    void build_panels() {
        this.build_parents_panel();
        this.build_distribution_panel();
    }

    private void build_parents_panel() {
        if (this.all_variable_names.length <= 2) {
            this.ap = new Panel();
            return;
        }
        this.pp = new Panel();
        this.pp.setLayout(new GridLayout(this.all_variable_names.length - 2, 2));
        this.parents_labels = new Label[this.all_variable_names.length - 2];
        this.parent_choices = new Choice[this.all_variable_names.length - 2];
        for (int i = 2; i < this.all_variable_names.length; ++i) {
            this.parents_labels[i - 2] = new Label(this.all_variable_names[i]);
            this.parents_labels[i - 2].setForeground(color_parents);
            this.parent_choices[i - 2] = new Choice();
            this.parent_choices[i - 2].setForeground(color_parents);
            for (int j = 0; j < this.all_variable_values[i].length; ++j) {
                this.parent_choices[i - 2].addItem(this.all_variable_values[i][j]);
            }
            this.pp.add(this.parents_labels[i - 2]);
            this.pp.add(this.parent_choices[i - 2]);
        }
        this.ap = new Panel();
        this.ap.setLayout(new BorderLayout());
        this.parents_announce = new Label(parents_announce_label, 1);
        this.parents_announce.setForeground(color_parents);
        this.ap.add("North", this.parents_announce);
        this.ap.add("Center", this.pp);
        this.separator_label = new Label("");
        this.ap.add("South", this.separator_label);
    }

    private void build_distribution_panel() {
        this.dp = new Panel();
        this.node_values_labels = new Label[this.all_variable_values[0].length];
        if (this.all_variable_names.length == 1) {
            this.dp.setLayout(new GridLayout(this.all_variable_values[0].length, 2));
            this.fields = new TextField[this.all_variable_values[0].length][1];
            for (int j = 0; j < this.all_variable_values[0].length; ++j) {
                this.node_values_labels[j] = new Label(this.all_variable_values[0][j]);
                this.dp.add(this.node_values_labels[j]);
                this.fields[j][0] = new TextField();
                this.fields[j][0].setText(String.valueOf(this.table_values[j]));
                this.dp.add(this.fields[j][0]);
            }
        } else {
            int i;
            this.dp.setLayout(new GridLayout(this.all_variable_values[0].length + 1, this.all_variable_values[1].length + 1));
            this.fields = new TextField[this.all_variable_values[0].length][this.all_variable_values[1].length];
            this.first_parent_name_label = new Label(this.all_variable_names[1]);
            this.first_parent_name_label.setForeground(color_parents);
            this.dp.add(this.first_parent_name_label);
            this.first_parent_values_labels = new Label[this.all_variable_values[1].length];
            for (i = 0; i < this.all_variable_values[1].length; ++i) {
                this.first_parent_values_labels[i] = new Label(this.all_variable_values[1][i]);
                this.first_parent_values_labels[i].setForeground(color_parents);
                this.dp.add(this.first_parent_values_labels[i]);
            }
            int jump = 1;
            if (this.all_variable_names.length > 1) {
                for (i = 2; i < this.all_variable_names.length; ++i) {
                    jump *= this.all_variable_values[i].length;
                }
            }
            for (int j = 0; j < this.all_variable_values[0].length; ++j) {
                this.node_values_labels[j] = new Label(this.all_variable_values[0][j]);
                this.dp.add(this.node_values_labels[j]);
                for (i = 0; i < this.all_variable_values[1].length; ++i) {
                    this.fields[j][i] = new TextField();
                    this.fields[j][i].setText(String.valueOf(this.table_values[(j * this.all_variable_values[1].length + i) * jump]));
                    this.dp.add(this.fields[j][i]);
                }
            }
        }
    }

    @Override
    public boolean action(Event evt, Object arg) {
        double value_set = 0.0;
        if (this.all_variable_names.length > 2) {
            for (int i = 0; i < this.parent_choices.length; ++i) {
                if (evt.target != this.parent_choices[i]) continue;
                this.update_table_for_parents();
                return true;
            }
        }
        return super.action(evt, arg);
    }

    private void update_table_for_parents() {
        if (this.all_variable_names.length == 1) {
            for (int j = 0; j < this.all_variable_values[0].length; ++j) {
                this.fields[j][0].setText(String.valueOf(this.table_values[j]));
            }
        } else if (this.all_variable_names.length == 2) {
            for (int i = 0; i < this.all_variable_values[0].length; ++i) {
                for (int j = 0; j < this.all_variable_values[1].length; ++j) {
                    this.fields[i][j].setText(String.valueOf(this.table_values[i * this.all_variable_values[1].length + j]));
                }
            }
        } else {
            int j;
            int i;
            int k;
            double value_set = 0.0;
            int[] parent_indexes = new int[this.all_variable_names.length];
            for (k = 0; k < this.parent_choices.length; ++k) {
                parent_indexes[k + 2] = this.parents_current_choices[k];
            }
            for (i = 0; i < this.fields.length; ++i) {
                for (j = 0; j < this.fields[i].length; ++j) {
                    try {
                        value_set = new Double(this.fields[i][j].getText());
                        parent_indexes[0] = i;
                        parent_indexes[1] = j;
                        this.table_values[this.get_location_from_indexes((int[])parent_indexes)] = value_set;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            for (k = 0; k < this.parent_choices.length; ++k) {
                parent_indexes[k + 2] = this.parent_choices[k].getSelectedIndex();
            }
            for (i = 0; i < this.all_variable_values[0].length; ++i) {
                for (j = 0; j < this.all_variable_values[1].length; ++j) {
                    parent_indexes[0] = i;
                    parent_indexes[1] = j;
                    this.fields[i][j].setText(String.valueOf(this.table_values[this.get_location_from_indexes(parent_indexes)]));
                }
            }
            for (k = 0; k < this.parents_current_choices.length; ++k) {
                this.parents_current_choices[k] = this.parent_choices[k].getSelectedIndex();
            }
        }
    }

    private void update_table_values() {
        if (this.all_variable_names.length == 1) {
            for (int i = 0; i < this.fields.length; ++i) {
                try {
                    this.table_values[i] = new Double(this.fields[i][0].getText());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else if (this.all_variable_names.length == 2) {
            for (int i = 0; i < this.fields.length; ++i) {
                for (int j = 0; j < this.fields[i].length; ++j) {
                    try {
                        this.table_values[i * this.all_variable_values[1].length + j] = new Double(this.fields[i][j].getText());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        } else {
            double value_set = 0.0;
            int[] parent_indexes = new int[this.all_variable_names.length];
            for (int k = 0; k < this.parent_choices.length; ++k) {
                parent_indexes[k + 2] = this.parent_choices[k].getSelectedIndex();
            }
            for (int i = 0; i < this.fields.length; ++i) {
                for (int j = 0; j < this.fields[i].length; ++j) {
                    try {
                        value_set = new Double(this.fields[i][j].getText());
                        parent_indexes[0] = i;
                        parent_indexes[1] = j;
                        this.table_values[this.get_location_from_indexes((int[])parent_indexes)] = value_set;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private int get_location_from_indexes(int[] indexes) {
        int pos = 0;
        int jump = 1;
        for (int i = this.all_variable_names.length - 1; i >= 0; --i) {
            pos += indexes[i] * jump;
            jump *= this.all_variable_values[i].length;
        }
        return pos;
    }
}

