/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.EditCredalSet;
import JavaBayesInterface.EditFunctionPanel;
import JavaBayesInterface.EditProbability;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;

class EditFunctionDialog
extends Dialog {
    Frame parent;
    EditFunctionPanel efp;
    Panel buttons;
    Button ok_button;
    Button dismiss_button;
    private static final int TOP_INSET = 5;
    private static final int LEFT_INSET = 10;
    private static final int RIGHT_INSET = 10;
    private static final int BOTTOM_INSET = 0;
    private static final String ok_label = "Apply";
    private static final String dialog_title = "Edit Function";
    private static final String dismiss_label = "Dismiss";

    public EditFunctionDialog(Frame parent, InferenceGraph ig, InferenceGraphNode ign) {
        super(parent, dialog_title, true);
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.efp = this.dispatch(ig, ign);
        this.buttons = new Panel();
        this.buttons.setLayout(new FlowLayout(1));
        this.ok_button = new Button(ok_label);
        this.dismiss_button = new Button(dismiss_label);
        this.buttons.add(this.ok_button);
        this.buttons.add(this.dismiss_button);
        this.add("Center", this.efp);
        this.add("South", this.buttons);
        this.pack();
    }

    private EditFunctionPanel dispatch(InferenceGraph ig, InferenceGraphNode ign) {
        if (ign.is_credal_set()) {
            return new EditCredalSet(ig, ign);
        }
        return new EditProbability(this, ig, ign);
    }

    @Override
    public void show() {
        Rectangle bounds = this.getParent().bounds();
        Rectangle abounds = this.bounds();
        this.move(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        super.show();
    }

    @Override
    public Insets insets() {
        Insets ins = super.insets();
        return new Insets(ins.top + 5, ins.left + 10, ins.bottom + 0, ins.right + 10);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            this.dispose();
        }
        return super.handleEvent(evt);
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.dismiss_button) {
            this.efp.dismiss();
            this.dispose();
            return true;
        }
        if (evt.target == this.ok_button) {
            this.efp.accept();
            return true;
        }
        return super.action(evt, arg);
    }
}

