/*
 * Decompiled with CFR 0.152.
 */
package InterchangeFormat;

import InterchangeFormat.IFBayesNet;
import InterchangeFormat.IFException;
import Parsers.BIFv01.BIFv01;
import Parsers.BIFv015.BIFv015;
import Parsers.XMLBIFv02.XMLBIFv02;
import Parsers.XMLBIFv03.XMLBIFv03;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class InterchangeFormat {
    InputStream istream;
    XMLBIFv03 xml_bif03;
    XMLBIFv02 xml_bif02;
    BIFv015 bif015;
    BIFv01 bif01;
    private static final int MARK_READ_LIMIT = 10000;

    public InterchangeFormat() {
    }

    public InterchangeFormat(InputStream is) {
        this.set_stream(is);
    }

    public void set_stream(InputStream is) {
        this.istream = new BufferedInputStream(is);
    }

    public void CompilationUnit() throws IFException {
        StringBuffer error_messages = new StringBuffer("Error messages\n");
        this.xml_bif03 = null;
        this.xml_bif02 = null;
        this.bif015 = null;
        this.bif01 = null;
        if (this.istream.markSupported()) {
            this.istream.mark(10000);
        } else {
            error_messages.append("\nNo support for reset operation.");
        }
        this.xml_bif03 = new XMLBIFv03(this.istream);
        try {
            this.xml_bif03.CompilationUnit();
            this.xml_bif03.invert_probability_tables();
        }
        catch (Throwable e4) {
            error_messages.append(e4);
            try {
                this.istream.reset();
            }
            catch (Exception e) {
                error_messages.append("\n\nReset not allowed!");
            }
            error_messages.append("Input stream reset!\n");
            this.xml_bif02 = new XMLBIFv02(this.istream);
            try {
                this.xml_bif02.CompilationUnit();
            }
            catch (Throwable e3) {
                error_messages.append(e3);
                try {
                    this.istream.reset();
                }
                catch (Exception e) {
                    error_messages.append("\n\nReset not allowed!");
                }
                error_messages.append("Input stream reset!\n");
                this.bif015 = new BIFv015(this.istream);
                try {
                    this.bif015.CompilationUnit();
                }
                catch (Throwable e2) {
                    error_messages.append(e2);
                    try {
                        this.istream.reset();
                    }
                    catch (Exception e) {
                        error_messages.append("\n\nReset not allowed!");
                    }
                    error_messages.append("Input stream reset!\n");
                    this.bif01 = new BIFv01(this.istream);
                    try {
                        this.bif01.CompilationUnit();
                    }
                    catch (Throwable e1) {
                        error_messages.append(e1);
                        throw new IFException(new String(error_messages));
                    }
                }
            }
        }
    }

    public IFBayesNet get_ifbn() {
        IFBayesNet ifbn = null;
        if (this.xml_bif03 != null) {
            ifbn = this.xml_bif03.get_ifbn();
        }
        if (ifbn != null) {
            return ifbn;
        }
        if (this.xml_bif02 != null) {
            ifbn = this.xml_bif02.get_ifbn();
        }
        if (ifbn != null) {
            return ifbn;
        }
        if (this.bif015 != null) {
            ifbn = this.bif015.get_ifbn();
        }
        if (ifbn != null) {
            return ifbn;
        }
        if (this.bif01 != null) {
            ifbn = this.bif01.get_ifbn();
        }
        if (ifbn != null) {
            return ifbn;
        }
        return ifbn;
    }
}

