/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.FinitelyGeneratedSet;
import CredalSets.QBProbabilityFunction;

public class EpsilonContaminatedSet
extends FinitelyGeneratedSet {
    double epsilon;

    public EpsilonContaminatedSet(ProbabilityFunction pf, double eps) {
        super((DiscreteFunction)pf, pf.get_values());
        this.epsilon = eps;
        if (this.epsilon < 0.0 || this.epsilon > 1.0) {
            this.epsilon = 0.0;
        }
    }

    public ProbabilityFunction posterior_marginal() {
        double one_minus_epsilon = 1.0 - this.epsilon;
        double[] lower_values = new double[this.values.length];
        double[] upper_values = new double[this.values.length];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            for (int i = 0; i < this.values.length; ++i) {
                lower_values[i] = this.values[i];
                upper_values[i] = this.values[i];
            }
        } else {
            int i;
            double summation = 0.0;
            for (i = 0; i < this.values.length; ++i) {
                summation += this.values[i];
            }
            for (i = 0; i < this.values.length; ++i) {
                lower_values[i] = one_minus_epsilon * this.values[i] / (one_minus_epsilon * summation + this.epsilon);
            }
            for (i = 0; i < this.values.length; ++i) {
                upper_values[i] = (one_minus_epsilon * this.values[i] + this.epsilon) / (one_minus_epsilon * summation + this.epsilon);
            }
        }
        return new QBProbabilityFunction(this.bn, this.variables, this.values, lower_values, upper_values, this.properties);
    }

    public double[] expected_values(DiscreteFunction df) {
        double one_minus_epsilon = 1.0 - this.epsilon;
        double[] results = new double[2];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            results[0] = df.get_value(((ProbabilityVariable)this.variables[0]).get_observed_index());
            results[1] = results[0];
        } else {
            double u_total = 0.0;
            for (int i = 0; i < this.number_values(); ++i) {
                u_total += df.get_value(i) * this.values[i];
            }
            double max_df_value = df.get_value(0);
            double min_df_value = df.get_value(0);
            for (int i = 1; i < df.number_values(); ++i) {
                if (max_df_value < df.get_value(i)) {
                    max_df_value = df.get_value(i);
                }
                if (!(min_df_value > df.get_value(i))) continue;
                min_df_value = df.get_value(i);
            }
            results[0] = one_minus_epsilon * u_total + this.epsilon * max_df_value;
            results[1] = one_minus_epsilon * u_total + this.epsilon * min_df_value;
        }
        return results;
    }

    public double[] posterior_expected_values(DiscreteFunction df) {
        double one_minus_epsilon = 1.0 - this.epsilon;
        double[] results = new double[2];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            results[0] = df.get_value(((ProbabilityVariable)this.variables[0]).get_observed_index());
            results[1] = results[0];
        } else {
            double p_total = 0.0;
            double u_total = 0.0;
            for (int i = 0; i < this.values.length; ++i) {
                p_total += this.values[i];
                u_total += df.get_value(i) * this.values[i];
            }
            double max_df_value = df.get_value(0);
            double min_df_value = df.get_value(0);
            for (int i = 1; i < df.number_values(); ++i) {
                if (max_df_value < df.get_value(i)) {
                    max_df_value = df.get_value(i);
                }
                if (!(min_df_value > df.get_value(i))) continue;
                min_df_value = df.get_value(i);
            }
            results[0] = (one_minus_epsilon * u_total + this.epsilon * min_df_value) / (one_minus_epsilon * p_total + this.epsilon);
            results[1] = (one_minus_epsilon * u_total + this.epsilon * max_df_value) / (one_minus_epsilon * p_total + this.epsilon);
        }
        return results;
    }
}

