/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.BayesNet;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;
import java.util.Date;

public class SaveBugs {
    BayesNet bn;

    public SaveBugs(BayesNet b_n) {
        this.bn = b_n;
    }

    public void save(PrintStream pstream) {
        pstream.println("# Bayesian Network in the BUGS Format");
        pstream.println("# Produced by BayesianNetworks package in JavaBayes");
        pstream.println("# Output created " + new Date());
        pstream.println("\n");
        this.save_model(pstream);
        this.save_variables(pstream);
        this.print_data_in(pstream);
        this.save_structure(pstream);
        this.save_data(pstream);
    }

    private void save_model(PrintStream pstream) {
        pstream.println("model " + this.bn.name + ";");
    }

    private void save_variables(PrintStream pstream) {
        int i;
        pstream.println("var");
        for (i = this.bn.probability_variables.length - 1; i >= 0; --i) {
            pstream.println("\t" + this.bn.probability_variables[i].name + ",");
        }
        for (i = this.bn.probability_functions.length - 1; i >= 0; --i) {
            ProbabilityFunction pf = this.bn.probability_functions[i];
            ProbabilityVariable pv = (ProbabilityVariable)pf.variables[0];
            pstream.print("\tp." + pv.name + "[" + pf.values.length + "]");
            if (i <= 0) continue;
            pstream.println(",");
        }
        pstream.println(";");
    }

    private void print_data_in(PrintStream pstream) {
        pstream.println("data in <user-defined-name-for-data-file>;");
    }

    private void save_structure(PrintStream pstream) {
        pstream.println("{");
        for (int i = this.bn.probability_functions.length - 1; i >= 0; --i) {
            ProbabilityFunction pf = this.bn.probability_functions[i];
            ProbabilityVariable pv = (ProbabilityVariable)pf.variables[0];
            pstream.print(pv.name + "  ~  dcat(p." + pv.name + "[");
            for (int j = 1; j < pf.variables.length; ++j) {
                pstream.print(pf.variables[j].name);
                pstream.print(",");
            }
            pstream.println("]);");
        }
        pstream.println("}\n\n");
    }

    private void save_data(PrintStream pstream) {
        pstream.println("list(");
        for (int i = this.bn.probability_functions.length - 1; i >= 0; --i) {
            int j;
            ProbabilityFunction pf = this.bn.probability_functions[i];
            ProbabilityVariable pv = (ProbabilityVariable)pf.variables[0];
            pstream.print("\tp." + pv.name + "  = c(");
            int step = 1;
            for (j = 1; j < pf.variables.length; ++j) {
                step *= pf.variables[j].values.length;
            }
            for (j = 0; j < step; ++j) {
                for (int k = 0; k < pf.variables[0].values.length; ++k) {
                    double value = pf.values[k * step + j];
                    pstream.print(" " + value);
                    if (k >= pf.variables[0].values.length - 1) continue;
                    pstream.print(",");
                }
                if (j >= step - 1) continue;
                pstream.print(",");
            }
            pstream.print(")");
            if (i <= 0) continue;
            pstream.println(",");
        }
        pstream.println(")\n");
    }
}

