/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.ConvertInterchangeFormat;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import BayesianNetworks.SaveBugs;
import InterchangeFormat.IFException;
import InterchangeFormat.InterchangeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class BayesNet {
    protected String name;
    protected Vector properties;
    protected ProbabilityVariable[] probability_variables;
    protected ProbabilityFunction[] probability_functions;
    protected DiscreteFunction utility_function;
    public static final int INVALID_INDEX = -1;
    public static final int BIF = 1;
    public static final int XML = 2;
    public static final int BUGS = 3;

    public BayesNet() {
    }

    public BayesNet(String n_n, int n_v, int n_f) {
        this();
        this.name = n_n;
        this.probability_variables = new ProbabilityVariable[n_v];
        this.probability_functions = new ProbabilityFunction[n_f];
    }

    public BayesNet(String n_n, Vector p) {
        this();
        this.name = n_n;
        this.properties = p;
    }

    public BayesNet(BayesNet bn) {
        this(bn.name, bn.probability_variables.length, bn.probability_functions.length);
        int i;
        for (i = 0; i < bn.probability_variables.length; ++i) {
            this.probability_variables[i] = bn.probability_variables[i];
        }
        for (i = 0; i < bn.probability_functions.length; ++i) {
            this.probability_functions[i] = bn.probability_functions[i];
        }
        this.properties = bn.properties;
    }

    public BayesNet(String s) throws IFException {
        this();
        StringBufferInputStream istream = new StringBufferInputStream(s);
        InterchangeFormat ifo = new InterchangeFormat(istream);
        ifo.CompilationUnit();
        this.translate(ifo);
    }

    public BayesNet(InputStream istream) throws IFException {
        this();
        InterchangeFormat ifo = new InterchangeFormat(istream);
        ifo.CompilationUnit();
        this.translate(ifo);
    }

    public BayesNet(URL context, String spec) throws IFException, IOException {
        this();
        URL url = new URL(context, spec);
        InputStream istream = url.openStream();
        InterchangeFormat ifo = new InterchangeFormat(istream);
        ifo.CompilationUnit();
        this.translate(ifo);
        istream.close();
    }

    public BayesNet(URL url) throws IFException, IOException {
        this();
        InputStream istream = url.openStream();
        InterchangeFormat ifo = new InterchangeFormat(istream);
        ifo.CompilationUnit();
        this.translate(ifo);
        istream.close();
    }

    protected void translate(InterchangeFormat ifo) {
        int i;
        ConvertInterchangeFormat cbn = new ConvertInterchangeFormat(ifo);
        this.name = cbn.get_name();
        this.properties = cbn.get_properties();
        this.probability_variables = cbn.get_probability_variables(this);
        this.probability_functions = cbn.get_probability_functions(this);
        this.process_properties();
        for (i = 0; i < this.probability_variables.length; ++i) {
            this.process_probability_variable_properties(i);
        }
        for (i = 0; i < this.probability_functions.length; ++i) {
            this.process_probability_function_properties(i);
        }
    }

    protected void process_properties() {
    }

    protected void process_probability_variable_properties(int index) {
        this.probability_variables[index].process_properties();
    }

    protected void process_probability_function_properties(int index) {
        this.probability_functions[index].process_properties();
    }

    public ProbabilityFunction get_function(ProbabilityVariable p_v) {
        for (int i = 0; i < this.probability_functions.length; ++i) {
            if (p_v.index != this.probability_functions[i].variables[0].index) continue;
            return this.probability_functions[i];
        }
        return null;
    }

    public void save_bif(PrintStream out) {
        int i;
        out.println("// Bayesian network ");
        if (this.name != null) {
            out.print("network \"" + this.name + "\" {");
        }
        if (this.probability_variables != null) {
            out.print(" //" + this.probability_variables.length + " variables");
        }
        if (this.probability_functions != null) {
            out.print(" and " + this.probability_functions.length + " probability distributions");
        }
        out.println();
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
        if (this.probability_variables != null) {
            for (i = 0; i < this.probability_variables.length; ++i) {
                if (this.probability_variables[i] == null) continue;
                this.probability_variables[i].print(out);
            }
        }
        if (this.probability_functions != null) {
            for (i = 0; i < this.probability_functions.length; ++i) {
                if (this.probability_functions[i] == null) continue;
                this.probability_functions[i].print(out);
            }
        }
    }

    public void save_embayes(PrintStream out) {
        int j;
        int i;
        out.println("import ebayes.data.*");
        out.println("class " + this.name + " extends BayesNet {");
        out.println("\tpublic " + this.name + "() {");
        out.println("\tsetName(\"" + this.name + "\");");
        for (i = 0; i < this.probability_variables.length; ++i) {
            out.println("\tCategoricalVariable " + this.probability_variables[i].name + " = ");
            out.println("\t\tnew CategoricalVariable(\"" + this.probability_variables[i].name + "\",");
            out.print("\t\t\tnew String[] {");
            for (j = 0; j < this.probability_variables[i].values.length; ++j) {
                out.print("\"" + this.probability_variables[i].values[j] + "\"");
                if (j == this.probability_variables[i].values.length - 1) continue;
                out.print(",");
            }
            out.println("});\n");
        }
        out.println("\n\n");
        for (i = 0; i < this.probability_functions.length; ++i) {
            out.println("\tCategoricalProbability p" + i + " = ");
            out.println("\t\tnew CategoricalProbability(" + this.probability_functions[i].variables[0].get_name() + ",");
            if (this.probability_functions[i].variables.length > 1) {
                out.print("\t\t\tnew CategoricalVariable[] {");
                for (j = 1; j < this.probability_functions[i].variables.length; ++j) {
                    out.print(this.probability_functions[i].variables[j].get_name());
                    if (j == this.probability_functions[i].variables.length - 1) continue;
                    out.print(", ");
                }
                out.println("}, ");
            }
            out.print("\t\t\tnew double[] {");
            for (j = 0; j < this.probability_functions[i].values.length; ++j) {
                out.print(this.probability_functions[i].values[j]);
                if (j == this.probability_functions[i].values.length - 1) continue;
                out.print(", ");
            }
            out.println("});\n");
        }
        out.println("\tsetVariables(");
        out.println("\t\tnew CategoricalVariable[]");
        out.print("\t\t\t{");
        for (i = 0; i < this.probability_variables.length; ++i) {
            out.print(this.probability_variables[i].get_name());
            if (i == this.probability_variables.length - 1) continue;
            out.print(", ");
        }
        out.println("} );\n");
        out.println("\tsetProbabilities(");
        out.println("\t\tnew CategoricalProbability[]");
        out.print("\t\t\t{");
        for (i = 0; i < this.probability_functions.length; ++i) {
            out.print("p" + i);
            if (i == this.probability_functions.length - 1) continue;
            out.print(", ");
        }
        out.println("} );\n");
        out.println("\n}");
    }

    public void save_xml(PrintStream pstream) {
        int i;
        pstream.println("<?xml version=\"1.0\" encoding=\"US-ASCII\"?>\n\n");
        pstream.println("<!--");
        pstream.println("\tBayesian network in XMLBIF v0.3 (BayesNet Interchange Format)");
        pstream.println("\tProduced by JavaBayes (http://www.cs.cmu.edu/~javabayes/");
        pstream.println("\tOutput created " + new Date());
        pstream.println("-->\n\n\n");
        pstream.println("<!-- DTD for the XMLBIF 0.3 format -->");
        pstream.println("<!DOCTYPE BIF [\n\t<!ELEMENT BIF ( NETWORK )*>\n\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n\t<!ELEMENT NAME (#PCDATA)>\n\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n\t<!ELEMENT OUTCOME (#PCDATA)>\n\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n\t<!ELEMENT FOR (#PCDATA)>\n\t<!ELEMENT GIVEN (#PCDATA)>\n\t<!ELEMENT TABLE (#PCDATA)>\n\t<!ELEMENT PROPERTY (#PCDATA)>\n]>\n\n");
        pstream.println("<BIF VERSION=\"0.3\">");
        pstream.println("<NETWORK>");
        if (this.name != null) {
            pstream.println("<NAME>" + this.name + "</NAME>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                pstream.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        pstream.println();
        pstream.println("<!-- Variables -->");
        if (this.probability_variables != null) {
            for (i = 0; i < this.probability_variables.length; ++i) {
                if (this.probability_variables[i] == null) continue;
                this.probability_variables[i].save_xml_0_3(pstream);
            }
        }
        pstream.println();
        pstream.println("<!-- Probability distributions -->");
        if (this.probability_functions != null) {
            for (i = 0; i < this.probability_functions.length; ++i) {
                if (this.probability_functions[i] == null) continue;
                this.probability_functions[i].save_xml_0_3(pstream);
            }
        }
        pstream.println();
        pstream.println("</NETWORK>");
        pstream.println("</BIF>");
    }

    public void save_xml_0_2(PrintStream pstream) {
        int i;
        pstream.println("<?XML VERSION=\"1.0\"?>\n\n");
        pstream.println("<!--");
        pstream.println("\tBayesian network in BIF (BayesNet Interchange Format)");
        pstream.println("\tProduced by JavaBayes (http://www.cs.cmu.edu/~javabayes/");
        pstream.println("\tOutput created " + new Date());
        pstream.println("-->\n\n\n");
        pstream.println("<!-- DTD for the BIF format -->");
        pstream.println("<!DOCTYPE BIF [\n\t<!ELEMENT BIF ( NETWORK )*>\n\t<!ELEMENT PROPERTY (#PCDATA)>\n\t<!ELEMENT TYPE (#PCDATA)>\n\t<!ELEMENT VALUE (#PCDATA)>\n\t<!ELEMENT NAME (#PCDATA)>\n\t<!ELEMENT NETWORK\n\t    ( NAME, ( PROPERTY | VARIABLE | PROBABILITY )* )>\n\t<!ELEMENT VARIABLE ( NAME, TYPE, ( VALUE |  PROPERTY )* ) >\n\t<!ELEMENT PROBABILITY\n\t    ( FOR | GIVEN | TABLE | ENTRY | DEFAULT | PROPERTY )* >\n\t<!ELEMENT FOR (#PCDATA)>\n\t<!ELEMENT GIVEN (#PCDATA)>\n\t<!ELEMENT TABLE (#PCDATA)>\n\t<!ELEMENT DEFAULT (TABLE)>\n\t<!ELEMENT ENTRY ( VALUE* , TABLE )>\n]>\n\n");
        pstream.println("<BIF>");
        pstream.println("<NETWORK>");
        if (this.name != null) {
            pstream.println("<NAME>" + this.name + "</NAME>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                pstream.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        pstream.println();
        pstream.println("<!-- Variables -->");
        if (this.probability_variables != null) {
            for (i = 0; i < this.probability_variables.length; ++i) {
                if (this.probability_variables[i] == null) continue;
                this.probability_variables[i].save_xml(pstream);
            }
        }
        pstream.println();
        pstream.println("<!-- Probability distributions -->");
        if (this.probability_functions != null) {
            for (i = 0; i < this.probability_functions.length; ++i) {
                if (this.probability_functions[i] == null) continue;
                this.probability_functions[i].save_xml(pstream);
            }
        }
        pstream.println();
        pstream.println("</NETWORK>");
        pstream.println("</BIF>");
    }

    public void save_bugs(PrintStream pstream) {
        SaveBugs sb = new SaveBugs(this);
        sb.save(pstream);
    }

    public String[][] get_all_evidence() {
        ProbabilityVariable pv;
        int i;
        Vector<ProbabilityVariable> evs = new Vector<ProbabilityVariable>();
        String[][] all_evs = null;
        for (i = 0; i < this.probability_variables.length; ++i) {
            pv = this.probability_variables[i];
            if (pv.observed_index == -1) continue;
            evs.addElement(pv);
        }
        all_evs = new String[evs.size()][];
        for (i = 0; i < all_evs.length; ++i) {
            all_evs[i] = new String[2];
        }
        int j = 0;
        Enumeration e = evs.elements();
        while (e.hasMoreElements()) {
            pv = (ProbabilityVariable)e.nextElement();
            all_evs[j][0] = pv.name;
            int aux = pv.observed_index;
            all_evs[j][1] = pv.values[aux];
        }
        return all_evs;
    }

    public int index_of_variable(String n_vb) {
        for (int i = 0; i < this.probability_variables.length; ++i) {
            if (!this.probability_variables[i].name.equals(n_vb)) continue;
            return i;
        }
        return -1;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        this.save_bif(out);
    }

    public String get_name() {
        return this.name;
    }

    public void set_name(String n) {
        this.name = n;
    }

    public Vector get_properties() {
        return this.properties;
    }

    public void set_properties(Vector prop) {
        this.properties = prop;
    }

    public void add_property(String prop) {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        this.properties.addElement(prop);
    }

    public void remove_property(String prop) {
        this.properties.removeElement(prop);
    }

    public void remove_property(int i) {
        this.properties.removeElementAt(i);
    }

    public int number_variables() {
        if (this.probability_variables == null) {
            return -1;
        }
        return this.probability_variables.length;
    }

    public int number_probability_functions() {
        if (this.probability_functions == null) {
            return -1;
        }
        return this.probability_functions.length;
    }

    public ProbabilityVariable get_probability_variable(int index) {
        if (index <= this.probability_variables.length) {
            return this.probability_variables[index];
        }
        return null;
    }

    public ProbabilityFunction get_probability_function(int index) {
        if (index <= this.probability_functions.length) {
            return this.probability_functions[index];
        }
        return null;
    }

    public ProbabilityVariable[] get_probability_variables() {
        return this.probability_variables;
    }

    public ProbabilityFunction[] get_probability_functions() {
        return this.probability_functions;
    }

    public DiscreteFunction get_utility_function() {
        return this.utility_function;
    }

    public void set_probability_variable(int index, String name, String[] v, Vector vec) {
        if (index <= this.probability_variables.length) {
            this.probability_variables[index] = new ProbabilityVariable(this, name, index, v, vec);
        }
    }

    public void set_probability_function(int index, ProbabilityVariable[] variables, double[] values, Vector vec) {
        if (index <= this.probability_functions.length) {
            this.probability_functions[index] = new ProbabilityFunction(this, variables, values, vec);
        }
    }

    public void set_probability_variable(int index, ProbabilityVariable p_v) {
        p_v.bn = this;
        p_v.index = index;
        this.probability_variables[index] = p_v;
    }

    public void set_probability_function(int index, ProbabilityFunction p_f) {
        p_f.bn = this;
        this.probability_functions[index] = p_f;
    }

    public void set_probability_variables(ProbabilityVariable[] pvs) {
        this.probability_variables = pvs;
    }

    public void set_probability_functions(ProbabilityFunction[] pfs) {
        this.probability_functions = pfs;
    }
}

