/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.DSeparation;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import java.util.Enumeration;
import java.util.Vector;

public class Ordering {
    BayesNet bn;
    String[] order;
    int explanation_status = 0;
    int ordering_type = 2;
    public static final int USER_DEFINED = 0;
    public static final int USER_ORDER = 1;
    public static final int MINIMUM_WEIGHT = 2;

    public Ordering(BayesNet b_n, String objective, int ot) {
        this.bn = b_n;
        this.explanation_status = this.obtain_explanation_status(b_n);
        this.ordering_type = ot;
        this.order = this.ordering(objective);
    }

    public Ordering(BayesNet b_n, String[] or) {
        this.bn = b_n;
        this.order = or;
        this.explanation_status = this.obtain_explanation_status(b_n);
    }

    public Ordering(BayesNet b_n, String objective, int ds, int ot) {
        this.bn = b_n;
        this.explanation_status = ds;
        this.ordering_type = ot;
        this.order = this.ordering(objective);
    }

    public Ordering(BayesNet b_n, String[] or, int ds) {
        this.bn = b_n;
        this.order = or;
        this.explanation_status = ds;
    }

    private int obtain_explanation_status(BayesNet b_n) {
        int explanation_status_flag = 0;
        for (int i = 0; i < b_n.number_variables(); ++i) {
            if (b_n.get_probability_variable(i).is_observed() || !b_n.get_probability_variable(i).is_explanation()) continue;
            explanation_status_flag = 1;
            break;
        }
        return explanation_status_flag;
    }

    private String[] ordering(String objective) {
        Vector variables_to_order = new Vector();
        int objective_index = this.bn.index_of_variable(objective);
        if (objective_index == -1) {
            objective_index = 0;
        }
        if (this.bn.get_probability_variable(objective_index).is_observed()) {
            String[] one_order = new String[]{this.bn.get_probability_variable(objective_index).get_name()};
            return one_order;
        }
        if (this.ordering_type == 1) {
            for (int i = 0; i < this.bn.number_variables(); ++i) {
                variables_to_order.addElement(this.bn.get_probability_variable(i));
            }
            return this.user_order(variables_to_order, objective_index);
        }
        if (this.explanation_status != 0) {
            for (int i = 0; i < this.bn.number_variables(); ++i) {
                variables_to_order.addElement(this.bn.get_probability_variable(i));
            }
        } else {
            DSeparation dsep = new DSeparation(this.bn);
            variables_to_order = dsep.all_affecting(objective_index);
        }
        return this.heuristic_order(variables_to_order, objective_index, this.ordering_type);
    }

    private String[] user_order(Vector variables_to_order, int objective_index) {
        boolean is_variable_explanation_flag = false;
        Vector<String> non_explanation_variables = new Vector<String>();
        Vector<String> explanation_variables = new Vector<String>();
        Enumeration e = variables_to_order.elements();
        while (e.hasMoreElements()) {
            ProbabilityVariable pv = (ProbabilityVariable)e.nextElement();
            if (pv.get_type() == 1) continue;
            switch (this.explanation_status) {
                case 0: {
                    is_variable_explanation_flag = false;
                    break;
                }
                case 1: {
                    is_variable_explanation_flag = pv.is_explanation();
                    break;
                }
                case 2: {
                    is_variable_explanation_flag = true;
                }
            }
            if (pv.is_observed()) {
                is_variable_explanation_flag = false;
            }
            if (is_variable_explanation_flag) {
                explanation_variables.addElement(pv.get_name());
                continue;
            }
            non_explanation_variables.addElement(pv.get_name());
        }
        String[] ord = new String[non_explanation_variables.size() + explanation_variables.size()];
        if (explanation_variables.size() == 0) {
            int i = 0;
            e = non_explanation_variables.elements();
            while (e.hasMoreElements()) {
                ord[i] = (String)e.nextElement();
                if (ord[i].equals(this.bn.get_probability_variable(objective_index).get_name())) {
                    --i;
                }
                ++i;
            }
            ord[i] = this.bn.get_probability_variable(objective_index).get_name();
        } else {
            int i = 0;
            e = non_explanation_variables.elements();
            while (e.hasMoreElements()) {
                ord[i] = (String)e.nextElement();
                ++i;
            }
            int j = i;
            e = explanation_variables.elements();
            while (e.hasMoreElements()) {
                ord[j] = (String)e.nextElement();
                ++j;
            }
        }
        return ord;
    }

    private String[] heuristic_order(Vector vo, int objective_index, int ordering_type) {
        ProbabilityVariable pv;
        int i;
        int PHASE_ONE = 1;
        int PHASE_TWO = 2;
        int number_variables_in_phase_two = 0;
        Vector<ProbabilityVariable> variables_to_order = new Vector<ProbabilityVariable>();
        Vector<ProbabilityVariable> elimination_ordering = new Vector<ProbabilityVariable>();
        int[] phase_markers = new int[this.bn.number_variables()];
        for (i = 0; i < phase_markers.length; ++i) {
            phase_markers[i] = PHASE_ONE;
        }
        Enumeration e = vo.elements();
        while (e.hasMoreElements()) {
            pv = (ProbabilityVariable)e.nextElement();
            if (pv.is_observed()) {
                elimination_ordering.addElement(pv);
                continue;
            }
            if (pv.get_type() == 1) continue;
            variables_to_order.addElement(pv);
            if (this.explanation_status != 2 && (this.explanation_status != 1 || !pv.is_explanation())) continue;
            phase_markers[pv.get_index()] = PHASE_TWO;
            ++number_variables_in_phase_two;
        }
        if (number_variables_in_phase_two == 0) {
            phase_markers[objective_index] = PHASE_TWO;
            number_variables_in_phase_two = 1;
        }
        Vector[] vectors = new Vector[this.bn.number_variables()];
        e = variables_to_order.elements();
        while (e.hasMoreElements()) {
            pv = (ProbabilityVariable)e.nextElement();
            vectors[pv.get_index()] = new Vector();
        }
        e = variables_to_order.elements();
        while (e.hasMoreElements()) {
            pv = (ProbabilityVariable)e.nextElement();
            ProbabilityFunction pf = this.bn.get_function(pv);
            vectors[pv.get_index()].addElement(pv);
            this.interconnect(this.bn, vectors, pf.get_variables());
        }
        int phase = number_variables_in_phase_two == variables_to_order.size() ? PHASE_TWO : PHASE_ONE;
        for (i = 0; i < variables_to_order.size(); ++i) {
            int j;
            long min_value = -1L;
            int min_index = -1;
            int number_variables_in_phase = 0;
            for (j = 0; j < vectors.length; ++j) {
                if (vectors[j] == null || phase_markers[j] != phase) continue;
                ++number_variables_in_phase;
                long value = this.obtain_value(vectors[j], ordering_type);
                if (value >= min_value && min_index != -1) continue;
                min_index = j;
                min_value = value;
            }
            if (phase == PHASE_ONE && number_variables_in_phase == 1) {
                phase = PHASE_TWO;
            }
            pv = this.bn.get_probability_variable(min_index);
            elimination_ordering.addElement(pv);
            for (j = 0; j < vectors.length; ++j) {
                if (vectors[j] == null) continue;
                vectors[j].removeElement(pv);
            }
            DiscreteVariable[] neighbors = new ProbabilityVariable[vectors[min_index].size()];
            j = 0;
            e = vectors[min_index].elements();
            while (e.hasMoreElements()) {
                pv = (ProbabilityVariable)e.nextElement();
                neighbors[j] = pv;
                ++j;
            }
            this.interconnect(this.bn, vectors, neighbors);
            vectors[min_index] = null;
        }
        String[] return_ordering = new String[elimination_ordering.size()];
        i = 0;
        e = elimination_ordering.elements();
        while (e.hasMoreElements()) {
            pv = (ProbabilityVariable)e.nextElement();
            return_ordering[i] = pv.get_name();
            ++i;
        }
        return return_ordering;
    }

    private long obtain_value(Vector v, int ordering_type) {
        long value = 0L;
        if (ordering_type == 2) {
            long weight = 1L;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                ProbabilityVariable pv = (ProbabilityVariable)e.nextElement();
                weight *= (long)pv.number_values();
            }
            value = weight;
        }
        return value;
    }

    private void interconnect(BayesNet bn, Vector[] vectors, DiscreteVariable[] variables_to_be_interconnected) {
        for (int i = 0; i < variables_to_be_interconnected.length - 1; ++i) {
            for (int j = i + 1; j < variables_to_be_interconnected.length; ++j) {
                this.interconnect(bn, vectors, variables_to_be_interconnected[i], variables_to_be_interconnected[j]);
            }
        }
    }

    private void interconnect(BayesNet bn, Vector[] vectors, DiscreteVariable pvi, DiscreteVariable pvj) {
        Vector iv = vectors[pvi.get_index()];
        Vector jv = vectors[pvj.get_index()];
        if (iv == null || jv == null) {
            return;
        }
        if (!iv.contains(pvj)) {
            iv.addElement(pvj);
        }
        if (!jv.contains(pvi)) {
            jv.addElement(pvi);
        }
    }
}

