/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityVariable;
import java.util.Stack;
import java.util.Vector;

class DSeparation {
    BayesNet bn;
    boolean[] above;
    boolean[] below;
    private static final int CONNECTED_VARIABLES = 0;
    private static final int AFFECTING_VARIABLES = 1;

    DSeparation(BayesNet b_n) {
        this.bn = b_n;
    }

    public Vector all_connected(int x) {
        return this.separation(x, 0);
    }

    public Vector all_affecting(int x) {
        return this.separation(x, 1);
    }

    private void separation_relations(int x, int flag) {
        int i;
        int nvertices = this.bn.number_probability_functions();
        if (flag == 1) {
            nvertices += nvertices;
        }
        boolean ans = false;
        this.above = new boolean[nvertices];
        this.below = new boolean[nvertices];
        int[] current = new int[2];
        for (i = 0; i < nvertices; ++i) {
            this.above[i] = false;
            this.below[i] = false;
        }
        Stack<int[]> stack = new Stack<int[]>();
        int[] Xabove = new int[]{x, 1};
        int[] Xbelow = new int[]{x, -1};
        stack.push(Xabove);
        stack.push(Xbelow);
        this.below[x] = true;
        this.above[x] = true;
        while (!stack.empty()) {
            int j;
            current = (int[])stack.pop();
            int v = current[0];
            int subscript = current[1];
            if (subscript < 0) {
                for (i = 0; i < nvertices; ++i) {
                    if (!this.adj(i, v, flag) || this.below[i] || this.is_separator(i, flag)) continue;
                    this.below[i] = true;
                    int[] Vbelow = new int[]{i, -1};
                    stack.push(Vbelow);
                }
                for (j = 0; j < nvertices; ++j) {
                    if (!this.adj(v, j, flag) || this.above[j]) continue;
                    this.above[j] = true;
                    int[] Tabove = new int[]{j, 1};
                    stack.push(Tabove);
                }
                this.above[v] = true;
                continue;
            }
            if (this.is_separator(v, flag)) {
                for (i = 0; i < nvertices; ++i) {
                    if (!this.adj(i, v, flag) || this.is_separator(i, flag) || this.below[i]) continue;
                    this.below[i] = true;
                    int[] Tbelow = new int[]{i, -1};
                    stack.push(Tbelow);
                }
                continue;
            }
            for (j = 0; j < nvertices; ++j) {
                if (!this.adj(v, j, flag) || this.above[j]) continue;
                this.above[j] = true;
                int[] Sabove = new int[]{j, 1};
                stack.push(Sabove);
            }
        }
    }

    private Vector separation(int x, int flag) {
        int nvertices = this.bn.number_probability_functions();
        Vector<ProbabilityVariable> d_separated_variables = new Vector<ProbabilityVariable>();
        this.separation_relations(x, flag);
        if (flag == 0) {
            for (int i = 0; i < nvertices; ++i) {
                if (!this.below[i] && !this.above[i]) continue;
                d_separated_variables.addElement(this.bn.get_probability_variable(i));
            }
        } else {
            for (int i = nvertices; i < nvertices + nvertices; ++i) {
                if (!this.below[i] && !this.above[i]) continue;
                d_separated_variables.addElement(this.bn.get_probability_variable(i - nvertices));
            }
        }
        return d_separated_variables;
    }

    private boolean is_separator(int i, int flag) {
        if (flag == 0 || flag == 1 && i < this.bn.number_probability_functions()) {
            return this.bn.get_probability_variable(i).is_observed();
        }
        return false;
    }

    private boolean adj(int index_from, int index_to, int flag) {
        DiscreteFunction pf = null;
        if (flag == 0 || flag == 1 && index_to < this.bn.number_probability_functions() && index_from < this.bn.number_probability_functions()) {
            int i;
            for (i = 0; i < this.bn.number_probability_functions(); ++i) {
                if (this.bn.get_probability_function(i).get_index(0) != index_to) continue;
                pf = this.bn.get_probability_function(i);
                break;
            }
            if (pf == null) {
                return false;
            }
            for (i = 1; i < pf.number_variables(); ++i) {
                if (pf.get_index(i) != index_from) continue;
                return true;
            }
            return false;
        }
        return index_from - index_to == this.bn.number_probability_functions();
    }
}

