/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Comparator;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastTable;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.structure.VectorSpace;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.DimensionException;

public abstract class Vector<F extends Field<F>>
implements VectorSpace<Vector<F>, F>,
ValueType,
Realtime {
    protected Vector() {
    }

    public abstract int getDimension();

    public abstract F get(int var1);

    @Override
    public abstract Vector<F> opposite();

    @Override
    public abstract Vector<F> plus(Vector<F> var1);

    public Vector<F> minus(Vector<F> that) {
        return this.plus((Vector<F>)that.opposite());
    }

    @Override
    public abstract Vector<F> times(F var1);

    @Override
    public abstract F times(Vector<F> var1);

    public Vector<F> cross(Vector<F> that) {
        if (this.getDimension() != 3 || that.getDimension() != 3) {
            throw new DimensionException("The cross product of two vectors requires 3-dimensional vectors");
        }
        FastTable elements = FastTable.newInstance();
        elements.add(((Field)this.get(1).times(that.get(2))).plus(((Field)this.get(2).times(that.get(1))).opposite()));
        elements.add(((Field)this.get(2).times(that.get(0))).plus(((Field)this.get(0).times(that.get(2))).opposite()));
        elements.add(((Field)this.get(0).times(that.get(1))).plus(((Field)this.get(1).times(that.get(0))).opposite()));
        DenseVector V = DenseVector.valueOf(elements);
        FastTable.recycle(elements);
        return V;
    }

    @Override
    public Text toText() {
        int dimension = this.getDimension();
        TextBuilder tmp = TextBuilder.newInstance();
        tmp.append('{');
        for (int i = 0; i < dimension; ++i) {
            tmp.append(this.get(i));
            if (i == dimension - 1) continue;
            tmp.append(", ");
        }
        tmp.append('}');
        Text txt = tmp.toText();
        TextBuilder.recycle(tmp);
        return txt;
    }

    public final String toString() {
        return this.toText().toString();
    }

    public boolean equals(Vector<F> that, Comparator<F> cmp) {
        if (this == that) {
            return true;
        }
        int dimension = this.getDimension();
        if (that.getDimension() != dimension) {
            return false;
        }
        int i = dimension;
        while (--i >= 0) {
            if (cmp.compare(this.get(i), that.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Vector)) {
            return false;
        }
        int dimension = this.getDimension();
        Vector v = (Vector)that;
        if (v.getDimension() != dimension) {
            return false;
        }
        int i = dimension;
        while (--i >= 0) {
            if (this.get(i).equals(v.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int dimension = this.getDimension();
        int code = 0;
        int i = dimension;
        while (--i >= 0) {
            code += this.get(i).hashCode();
        }
        return code;
    }

    @Override
    public abstract Vector<F> copy();
}

