/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Comparator;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.util.FastTable;
import javolution.util.Index;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseMatrix;
import org.jscience.mathematics.vector.SparseVector;

public final class LUDecomposition<F extends Field<F>> {
    public static final Comparator<Field> NUMERIC_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field left, Field right) {
            if (left instanceof Number && right instanceof Number) {
                return ((Number)((Object)left)).isLargerThan((Number)((Object)right)) ? 1 : -1;
            }
            if (left.equals(left.plus(left))) {
                return -1;
            }
            if (right.equals(right.plus(right))) {
                return 1;
            }
            return 0;
        }
    };
    private static final LocalContext.Reference<Comparator<Field>> PIVOT_COMPARATOR = new LocalContext.Reference<Comparator<Field>>(NUMERIC_COMPARATOR);
    private int _n;
    private final FastTable<Index> _pivots = new FastTable();
    private DenseMatrix<F> _LU;
    private int _permutationCount;
    private static final ObjectFactory<LUDecomposition> FACTORY = new ObjectFactory<LUDecomposition>(){

        @Override
        protected LUDecomposition create() {
            return new LUDecomposition();
        }

        @Override
        protected void cleanup(LUDecomposition lu) {
            lu._LU = null;
        }
    };

    public static <F extends Field<F>> LUDecomposition<F> valueOf(Matrix<F> source) {
        if (!source.isSquare()) {
            throw new DimensionException("Matrix is not square");
        }
        int dimension = source.getNumberOfRows();
        LUDecomposition lu = FACTORY.object();
        lu._n = dimension;
        lu._permutationCount = 0;
        lu.construct(source);
        return lu;
    }

    private void construct(Matrix<F> source) {
        this._LU = source instanceof DenseMatrix ? ((DenseMatrix)source).copy() : DenseMatrix.valueOf(source);
        this._pivots.clear();
        for (int i = 0; i < this._n; ++i) {
            this._pivots.add(Index.valueOf(i));
        }
        Comparator<Field> cmp = LUDecomposition.getPivotComparator();
        int n = this._n;
        for (int k = 0; k < this._n; ++k) {
            int i;
            if (cmp != null) {
                int pivot = k;
                for (i = k + 1; i < n; ++i) {
                    if (cmp.compare((Field)this._LU.get(i, k), (Field)this._LU.get(pivot, k)) <= 0) continue;
                    pivot = i;
                }
                if (pivot != k) {
                    int j;
                    for (j = 0; j < n; ++j) {
                        F tmp = this._LU.get(pivot, j);
                        this._LU.set(pivot, j, this._LU.get(k, j));
                        this._LU.set(k, j, tmp);
                    }
                    j = this._pivots.get(pivot).intValue();
                    this._pivots.set(pivot, this._pivots.get(k));
                    this._pivots.set(k, Index.valueOf(j));
                    ++this._permutationCount;
                }
            }
            Field lukkInv = (Field)this._LU.get(k, k).inverse();
            for (i = k + 1; i < n; ++i) {
                this._LU.set(i, k, this._LU.get(i, k).times((Field)lukkInv));
                for (int j = k + 1; j < n; ++j) {
                    this._LU.set(i, j, (Field)this._LU.get(i, j).plus(this._LU.get(i, k).times(this._LU.get(k, j).opposite())));
                }
            }
        }
    }

    public static void setPivotComparator(Comparator<Field> cmp) {
        PIVOT_COMPARATOR.set(cmp);
    }

    public static Comparator<Field> getPivotComparator() {
        return PIVOT_COMPARATOR.get();
    }

    public DenseMatrix<F> solve(Matrix<F> B) {
        int j;
        F luik;
        int i;
        int k;
        int j2;
        if (this._n != B.getNumberOfRows()) {
            throw new DimensionException("Input vector has " + B.getNumberOfRows() + " rows instead of " + this._n);
        }
        int n = B.getNumberOfColumns();
        DenseMatrix<F> X = this.createNullDenseMatrix(this._n, n);
        for (int i2 = 0; i2 < this._n; ++i2) {
            for (j2 = 0; j2 < n; ++j2) {
                X.set(i2, j2, B.get(this._pivots.get(i2).intValue(), j2));
            }
        }
        for (k = 0; k < this._n; ++k) {
            for (i = k + 1; i < this._n; ++i) {
                luik = this._LU.get(i, k);
                for (j = 0; j < n; ++j) {
                    X.set(i, j, (Field)X.get(i, j).plus(luik.times(X.get(k, j).opposite())));
                }
            }
        }
        for (k = this._n - 1; k >= 0; --k) {
            for (j2 = 0; j2 < n; ++j2) {
                X.set(k, j2, (Field)((Field)this._LU.get(k, k).inverse()).times(X.get(k, j2)));
            }
            for (i = 0; i < k; ++i) {
                luik = this._LU.get(i, k);
                for (j = 0; j < n; ++j) {
                    X.set(i, j, (Field)X.get(i, j).plus(luik.times(X.get(k, j).opposite())));
                }
            }
        }
        return X;
    }

    private DenseMatrix<F> createNullDenseMatrix(int m, int n) {
        DenseMatrix M = DenseMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            DenseVector V = DenseVector.newInstance();
            M._rows.add(V);
            for (int j = 0; j < n; ++j) {
                V._elements.add(null);
            }
        }
        return M;
    }

    public DenseMatrix<F> inverse() {
        int i;
        int j;
        int i2;
        int n = this._n;
        DenseMatrix<F> R = this.createNullDenseMatrix(n, n);
        for (i2 = 0; i2 < n; ++i2) {
            for (j = i2; j < n; ++j) {
                R.set(i2, j, this._LU.get(i2, j));
            }
        }
        for (int j2 = n - 1; j2 >= 0; --j2) {
            R.set(j2, j2, (Field)R.get(j2, j2).inverse());
            for (i = j2 - 1; i >= 0; --i) {
                Field sum = (Field)R.get(i, j2).times(R.get(j2, j2).opposite());
                for (int k = j2 - 1; k > i; --k) {
                    sum = (Field)sum.plus(R.get(i, k).times(R.get(k, j2).opposite()));
                }
                R.set(i, j2, ((Field)R.get(i, i).inverse()).times(sum));
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (j = n - 2; j >= 0; --j) {
                for (int k = j + 1; k < n; ++k) {
                    F lukj = this._LU.get(k, j);
                    if (R.get(i2, j) != null) {
                        R.set(i2, j, (Field)R.get(i2, j).plus(R.get(i2, k).times(lukj.opposite())));
                        continue;
                    }
                    R.set(i2, j, (Field)R.get(i2, k).times(lukj.opposite()));
                }
            }
        }
        FastTable<F> tmp = FastTable.newInstance();
        for (i = 0; i < n; ++i) {
            int j3;
            tmp.reset();
            for (j3 = 0; j3 < n; ++j3) {
                tmp.add(R.get(i, j3));
            }
            for (j3 = 0; j3 < n; ++j3) {
                R.set(i, this._pivots.get(j3).intValue(), (Field)tmp.get(j3));
            }
        }
        FastTable.recycle(tmp);
        return R;
    }

    public F determinant() {
        Object product = this._LU.get(0, 0);
        for (int i = 1; i < this._n; ++i) {
            product = (Field)product.times(this._LU.get(i, i));
        }
        return (F)((this._permutationCount & 1) == 0 ? product : (Field)product.opposite());
    }

    public DenseMatrix<F> getLower(F zero, F one) {
        Matrix L = this._LU.copy();
        for (int j = 0; j < this._n; ++j) {
            for (int i = 0; i < j; ++i) {
                ((DenseMatrix)L).set(i, j, zero);
            }
            ((DenseMatrix)L).set(j, j, one);
        }
        return L;
    }

    public DenseMatrix<F> getUpper(F zero) {
        Matrix U = this._LU.copy();
        for (int j = 0; j < this._n; ++j) {
            for (int i = j + 1; i < this._n; ++i) {
                ((DenseMatrix)U).set(i, j, zero);
            }
        }
        return U;
    }

    public SparseMatrix<F> getPermutation(F zero, F one) {
        SparseMatrix<F> P = SparseMatrix.newInstance(this._n, zero, false);
        for (int i = 0; i < this._n; ++i) {
            ((SparseVector)P.getRow((int)this._pivots.get((int)i).intValue()))._elements.put(Index.valueOf(i), one);
        }
        return P;
    }

    public DenseMatrix<F> getLU() {
        return this._LU;
    }

    public FastTable<Index> getPivots() {
        return this._pivots;
    }

    private LUDecomposition() {
    }
}

