/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.lang.Realtime;
import javolution.text.Text;
import javolution.xml.XMLSerializable;
import org.jscience.mathematics.structure.Ring;

public abstract class Number<T extends Number<T>>
extends java.lang.Number
implements Ring<T>,
Comparable<T>,
Realtime,
XMLSerializable {
    public abstract boolean isLargerThan(T var1);

    @Override
    public abstract long longValue();

    @Override
    public abstract double doubleValue();

    @Override
    public abstract int compareTo(T var1);

    public final boolean isLessThan(T that) {
        return this.compareTo(that) < 0;
    }

    public final boolean isGreaterThan(T that) {
        return this.compareTo(that) > 0;
    }

    public T minus(T that) {
        return (T)((Number)this.plus(that.opposite()));
    }

    public T pow(int exp) {
        if (exp <= 0) {
            throw new IllegalArgumentException("exp: " + exp + " should be a positive number");
        }
        Number t = this;
        if (exp == 1) {
            return (T)t;
        }
        if (exp == 2) {
            return (T)t.times(t);
        }
        if (exp == 3) {
            return (T)t.times(t).times(t);
        }
        int halfExp = exp >> 1;
        return (T)((Number)this.pow(halfExp).times(this.pow(exp - halfExp)));
    }

    @Override
    public final byte byteValue() {
        return (byte)this.longValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.longValue();
    }

    @Override
    public final int intValue() {
        return (int)this.longValue();
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public abstract Text toText();

    @Override
    public abstract Number<T> copy();

    public final String toString() {
        return this.toText().toString();
    }
}

