/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.economics.money;

import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javolution.context.LocalContext;
import javolution.util.LocalMap;
import org.jscience.economics.money.Money;

public class Currency
extends DerivedUnit<Money> {
    public static final Currency AUD = new Currency("AUD");
    public static final Currency CAD = new Currency("CAD");
    public static final Currency CNY = new Currency("CNY");
    public static final Currency EUR = new Currency("EUR");
    public static final Currency GBP = new Currency("GBP");
    public static final Currency JPY = new Currency("JPY");
    public static final Currency KRW = new Currency("KRW");
    public static final Currency TWD = new Currency("TWD");
    public static final Currency USD = new Currency("USD");
    private static final LocalContext.Reference<Currency> REFERENCE = new LocalContext.Reference();
    private static final LocalMap<String, Double> TO_REFERENCE = new LocalMap();
    private final Converter _toBaseUnit;
    private static final long serialVersionUID = 1L;

    public Currency(String code) {
        this._toBaseUnit = new Converter(code, false);
        UnitFormat.getInstance().label(this, code);
    }

    public String getCode() {
        return this._toBaseUnit._code;
    }

    public int getDefaultFractionDigits() {
        return this.equals(JPY) || this.equals(KRW) ? 0 : 2;
    }

    public static void setReferenceCurrency(Currency currency) {
        REFERENCE.set(currency);
        TO_REFERENCE.clear();
        TO_REFERENCE.put(currency.getCode(), 1.0);
    }

    public static Currency getReferenceCurrency() {
        return REFERENCE.get();
    }

    public void setExchangeRate(double refAmount) {
        TO_REFERENCE.put(this.getCode(), refAmount);
    }

    public double getExchangeRate() {
        Double refAmount = TO_REFERENCE.get(this.getCode());
        if (refAmount == null) {
            throw new ConversionException("Exchange rate not set for " + this.getCode());
        }
        return refAmount;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Currency)) {
            return false;
        }
        Currency that = (Currency)obj;
        return this._toBaseUnit.equals(that._toBaseUnit);
    }

    @Override
    public int hashCode() {
        return this._toBaseUnit.hashCode();
    }

    @Override
    public Unit<? super Money> getStandardUnit() {
        return Money.BASE_UNIT;
    }

    @Override
    public UnitConverter toStandardUnit() {
        return this._toBaseUnit;
    }

    private static class Converter
    extends UnitConverter {
        String _code;
        boolean _invert;
        private static final long serialVersionUID = 1L;

        private Converter(String code, boolean invert) {
            this._code = code;
            this._invert = invert;
        }

        @Override
        public UnitConverter inverse() {
            return new Converter(this._code, !this._invert);
        }

        @Override
        public double convert(double x) throws ConversionException {
            Double refAmount = (Double)TO_REFERENCE.get(this._code);
            if (refAmount == null) {
                throw new ConversionException("Exchange rate not set for " + this._code);
            }
            return this._invert ? x / refAmount : x * refAmount;
        }

        @Override
        public boolean isLinear() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Converter)) {
                return false;
            }
            Converter that = (Converter)obj;
            return this._code.equals(that._code) && this._invert == that._invert;
        }

        @Override
        public int hashCode() {
            return this._invert ? this._code.hashCode() : -this._code.hashCode();
        }
    }
}

