/*
 * Decompiled with CFR 0.152.
 */
package jline1;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import jline1.CompletionHandler;
import jline1.ConsoleReader;
import jline1.CursorBuffer;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
    private boolean eagerNewlines = true;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader, List candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            String bufString = buf.toString();
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates, this.eagerNewlines);
        reader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, String value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    public static final void printCandidates(ConsoleReader reader, Collection candidates, boolean eagerNewlines) throws IOException {
        HashSet distinct = new HashSet(candidates);
        if (distinct.size() > reader.getAutoprintThreshhold()) {
            int c;
            if (!eagerNewlines) {
                reader.printNewline();
            }
            reader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates.size())) + " ");
            reader.flushConsole();
            String noOpt = loc.getString("display-candidates-no");
            String yesOpt = loc.getString("display-candidates-yes");
            while ((c = reader.readCharacter(new char[]{yesOpt.charAt(0), noOpt.charAt(0)})) != -1) {
                if (noOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader.printNewline();
                    return;
                }
                if (yesOpt.startsWith(new String(new char[]{(char)c}))) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates.size()) {
            ArrayList copy = new ArrayList();
            for (Object next : candidates) {
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates = copy;
        }
        reader.printNewline();
        reader.printColumns(candidates);
    }

    private final String getUnambiguousCompletions(List candidates) {
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuffer candidate = new StringBuffer();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }
}

