/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.Message;
import hep.io.root.daemon.xrootd.Operation;
import hep.io.root.daemon.xrootd.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoginOperation
extends Operation<LoginSession> {
    private static AtomicInteger pseudoPid = new AtomicInteger(1);

    LoginOperation(String user) {
        super("login", new LoginMessage(user), new LoginCallback());
    }

    static class LoginSession {
        private byte[] session;
        private byte[] security;

        LoginSession(Response response) throws IOException {
            int dLen = response.getLength();
            if (dLen > 0) {
                int i;
                this.session = new byte[16];
                for (i = 0; i < this.session.length; ++i) {
                    this.session[i] = response.getData().get();
                }
                if (dLen > 16) {
                    this.security = new byte[dLen - 16];
                    for (i = 0; i < this.security.length; ++i) {
                        this.security[i] = response.getData().get();
                    }
                }
            }
        }

        public byte[] getSecurity() {
            return this.security;
        }

        public byte[] getSession() {
            return this.session;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Session: ");
            for (byte b : this.session) {
                builder.append(String.format("%02x", b));
            }
            if (this.security != null) {
                builder.append("  Security: ");
                for (byte b : this.security) {
                    builder.append(String.format("%02x", b));
                }
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoginCallback
    extends Callback<LoginSession> {
        private LoginCallback() {
        }

        @Override
        LoginSession responseReady(Response response) throws IOException {
            return new LoginSession(response);
        }
    }

    private static class LoginMessage
    extends Message {
        LoginMessage(String userName) {
            super(3007);
            byte[] user;
            this.writeInt(pseudoPid.getAndIncrement());
            try {
                user = userName.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Not possible", ex);
            }
            for (int i = 0; i < 8; ++i) {
                this.writeByte(i < user.length ? user[i] : 0);
            }
            this.writeByte(0);
            this.writeByte(0);
            this.writeByte(130);
            this.writeByte(0);
        }
    }
}

