/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.FutureResponse;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.MultiplexorManager;
import hep.io.root.daemon.xrootd.Operation;
import hep.io.root.daemon.xrootd.Response;
import hep.io.root.daemon.xrootd.ResponseListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Dispatcher {
    private static Logger logger = Logger.getLogger(Dispatcher.class.getName());
    private static final int WAIT_TIMEOUT = Integer.getInteger("hep.io.root.deamon.xrootd.timeout", 3000);
    private static final int WAIT_LIMIT = Integer.getInteger("hep.io.root.deamon.xrootd.waitLimit", 1000);
    private static Dispatcher theDispatcher = new Dispatcher();
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
    private MultiplexorManager manager = new MultiplexorManager(this.scheduler);

    private Dispatcher() {
    }

    static Dispatcher instance() {
        return theDispatcher;
    }

    <V> FutureResponse<V> send(Destination destination, Operation<V> operation) {
        MessageExecutor<V> executor = new MessageExecutor<V>(destination, operation);
        executor.run();
        return new FutureMessageResponse<V>(executor);
    }

    private void resend(MessageExecutor executor) {
        this.resend(executor, 0L, TimeUnit.SECONDS);
    }

    private void resend(MessageExecutor executor, long time, TimeUnit units) {
        this.scheduler.schedule(executor, time, units);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageExecutor<V>
    implements ResponseListener,
    Runnable,
    MultiplexorManager.MultiplexorReadyCallback {
        private Operation<V> operation;
        private V result;
        private IOException exception;
        private boolean isDone = false;
        private int errors = 0;
        private Destination destination;
        private long startTime = System.currentTimeMillis();

        MessageExecutor(Destination destination, Operation<V> operation) {
            this.destination = destination;
            this.operation = operation;
        }

        @Override
        public void run() {
            try {
                Multiplexor multiplexor = Dispatcher.this.manager.getMultiplexor(this.destination, this);
                if (multiplexor == null) {
                    return;
                }
                Multiplexor expectedMultiplexor = this.operation.getMultiplexor();
                if (expectedMultiplexor != null && multiplexor != expectedMultiplexor) {
                    Operation preReq = this.operation.getPrerequisite();
                    ChainCallback cc = new ChainCallback(preReq.getCallback(), this);
                    MessageExecutor executor = new MessageExecutor(this.destination, new Operation(preReq.getName() + "-chain", preReq.getMessage(), cc));
                    Dispatcher.this.resend(executor);
                } else {
                    multiplexor.sendMessage(this.operation.getMessage(), this);
                    logger.fine(String.format("Sent %s to %s after %,dms", this.operation, multiplexor, System.currentTimeMillis() - this.startTime));
                }
            }
            catch (IOException x) {
                this.handleSocketError(x);
            }
            catch (Throwable x) {
                logger.log(Level.SEVERE, "Unexpected error while sending message", x);
            }
        }

        @Override
        public void multiplexorReady(Multiplexor multiplexor) {
            Dispatcher.this.resend(this);
        }

        @Override
        public synchronized void handleError(IOException exception) {
            this.exception = exception;
            this.isDone = true;
            this.notify();
            logger.fine(String.format("Received error for %s after %,dms", this.operation, System.currentTimeMillis() - this.startTime));
        }

        @Override
        public void reschedule(long time, TimeUnit units) {
            Dispatcher.this.resend(this, time, units);
        }

        @Override
        public void handleRedirect(String host, int port) throws UnknownHostException {
            Destination redirected = this.destination.getRedirected(host, port);
            this.operation.getCallback().clear();
            this.destination = redirected;
            Dispatcher.this.resend(this);
        }

        @Override
        public synchronized void handleResponse(Response response) throws IOException {
            this.result = this.operation.getCallback().responseReady(response);
            if (response.isComplete()) {
                this.isDone = true;
                this.notify();
                logger.fine(String.format("Received response %s from %s after %,dms", this.operation, response.getMultiplexor(), System.currentTimeMillis() - this.startTime));
            }
        }

        @Override
        public void handleSocketError(IOException iOException) {
            ++this.errors;
            if (this.errors > 1 && this.destination.getPrevious() != null) {
                this.destination = this.destination.getPrevious();
            }
            this.operation.getCallback().clear();
            Dispatcher.this.resend(this, 1L, TimeUnit.SECONDS);
        }

        synchronized V getResult() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        synchronized boolean isDone() {
            return this.isDone;
        }

        public String toString() {
            return this.operation + "@" + this.destination;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FutureMessageResponse<V>
    extends FutureResponse<V> {
        private final MessageExecutor<V> listener;

        FutureMessageResponse(MessageExecutor<V> listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getResponse(long timeout, TimeUnit timeUnit) throws IOException {
            long start = System.nanoTime();
            long timeoutNS = timeUnit.toNanos(timeout);
            long waitTimeoutNS = TimeUnit.NANOSECONDS.convert(WAIT_TIMEOUT, TimeUnit.MILLISECONDS);
            try {
                long totalWaitNS;
                do {
                    MessageExecutor<V> messageExecutor = this.listener;
                    synchronized (messageExecutor) {
                        if (this.listener.isDone()) {
                            return this.listener.getResult();
                        }
                        TimeUnit.NANOSECONDS.timedWait(this.listener, Math.min(timeoutNS, waitTimeoutNS));
                        if (this.listener.isDone()) {
                            return this.listener.getResult();
                        }
                    }
                    totalWaitNS = System.nanoTime() - start;
                    if (totalWaitNS > timeoutNS) {
                        return null;
                    }
                    logger.warning("Waiting for response for " + TimeUnit.SECONDS.convert(totalWaitNS, TimeUnit.NANOSECONDS) + " secs " + this.listener.toString());
                } while (totalWaitNS < (long)WAIT_LIMIT * waitTimeoutNS);
                throw new IOException("Timeout waiting for response after " + TimeUnit.SECONDS.convert(totalWaitNS, TimeUnit.NANOSECONDS) + "secs");
            }
            catch (InterruptedException x) {
                InterruptedIOException iio = new InterruptedIOException("Xrootd IO interrupted");
                iio.initCause(x);
                throw iio;
            }
        }

        @Override
        public boolean isDone() {
            return this.listener.isDone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainCallback<V>
    extends Callback<V> {
        private MessageExecutor originalMessageExecutor;
        private Callback<V> chain;

        ChainCallback(Callback<V> chain, MessageExecutor originalMessageExecutor) {
            this.originalMessageExecutor = originalMessageExecutor;
            this.chain = chain;
        }

        @Override
        public V responseReady(Response response) throws IOException {
            V result = this.chain.responseReady(response);
            if (response.isComplete()) {
                this.originalMessageExecutor.destination = response.getDestination();
                Dispatcher.this.resend(this.originalMessageExecutor);
            }
            return result;
        }

        @Override
        public void clear() {
            this.chain.clear();
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "xrootd-dispatcher");
            t.setDaemon(true);
            return t;
        }
    }
}

