/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;

public class Destination {
    private String host;
    private int port;
    private String userName;
    private Destination previous;
    private InetAddress[] addresses;
    private InetAddress address;

    private Destination() {
    }

    public Destination(String host, int port, String userName) throws UnknownHostException {
        this.host = host;
        this.port = port <= 0 ? 1094 : port;
        this.userName = userName;
        this.addresses = InetAddress.getAllByName(host);
        if (this.addresses.length == 0) {
            throw new UnknownHostException("No valid IP addresses");
        }
        Collections.shuffle(Arrays.asList(this.addresses));
        this.address = this.addresses[0];
    }

    String getAddressAndPort() {
        return this.address + ":" + this.port;
    }

    Destination getAlternateDestination(int index) {
        if (index == 0 || this.addresses.length < 2) {
            return this;
        }
        return this.copy(index);
    }

    private Destination copy(int index) {
        Destination dest = new Destination();
        dest.host = this.host;
        dest.port = this.port;
        dest.userName = this.userName;
        dest.previous = this.previous;
        dest.addresses = this.addresses;
        dest.address = this.addresses[index % this.addresses.length];
        return dest;
    }

    int getPort() {
        return this.port;
    }

    Destination getPrevious() {
        return this.previous;
    }

    Destination getRedirected(String host, int port) throws UnknownHostException {
        Destination dest = new Destination(host, port, this.userName);
        dest.previous = this;
        return dest;
    }

    InetAddress getAddress() {
        return this.address;
    }

    SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }

    String getUserName() {
        return this.userName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Destination) {
            Destination that = (Destination)obj;
            return this.address.equals(that.address) && this.port == that.port && this.userName.equals(that.userName);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode() + this.port + this.userName.hashCode();
    }

    public String toString() {
        return "[" + this.address + ":" + this.port + ":" + this.userName + "]";
    }
}

