/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.test.holiday.HolidayCalendarFactoryTestImpl;
import org.jfin.date.test.holiday.LondonHolidayCalendar;

public class HolidayCalendarFactoryTest
extends TestCase {
    public void testGetHolidayCalendar() throws HolidayCalendarException {
        HolidayCalendarFactory testHolidayCalendarFactory = HolidayCalendarFactory.newInstance("org.jfin.date.test.holiday.HolidayCalendarFactoryTestImpl");
        HolidayCalendar LnB = testHolidayCalendarFactory.getHolidayCalendar("LnB");
        HolidayCalendar NyB = testHolidayCalendarFactory.getHolidayCalendar("NyB");
        String[] holidayCalendarArray = new String[]{"LnB", "NyB"};
        HolidayCalendar combined = testHolidayCalendarFactory.getHolidayCalendar(holidayCalendarArray);
        GregorianCalendar fd1 = new GregorianCalendar(2006, 11, 25);
        GregorianCalendar fd2 = new GregorianCalendar(2007, 0, 1);
        HolidayCalendarFactoryTest.assertTrue((boolean)LnB.isHoliday(fd1));
        HolidayCalendarFactoryTest.assertFalse((boolean)NyB.isHoliday(fd1));
        HolidayCalendarFactoryTest.assertTrue((boolean)combined.isHoliday(fd1));
        HolidayCalendarFactoryTest.assertFalse((boolean)LnB.isHoliday(fd2));
        HolidayCalendarFactoryTest.assertTrue((boolean)NyB.isHoliday(fd2));
        HolidayCalendarFactoryTest.assertTrue((boolean)combined.isHoliday(fd2));
    }

    public void testGetSpecificHolidayCalendarFactory() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.test.holiday.HolidayCalendarFactoryTestImpl");
        HolidayCalendarFactoryTest.assertTrue((boolean)(HolidayCalendarFactory.newInstance() instanceof HolidayCalendarFactoryTestImpl));
        System.clearProperty("jfin.HolidayCalendarFactory");
    }

    public void testHolidayCalendarFactoryNotFound() {
        System.setProperty("jfin.HolidayCalendarFactory", "does.not.exist");
        try {
            HolidayCalendarFactory.newInstance();
        }
        catch (HolidayCalendarException e) {
            System.clearProperty("jfin.HolidayCalendarFactory");
            return;
        }
        System.clearProperty("jfin.HolidayCalendarFactory");
        HolidayCalendarFactoryTest.fail((String)"Found holiday calendar, even though a non existant one was specified in the jfin.HolidayCalendarFactory property");
    }

    public void testHolidayCalendarFactoryWrongClass() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.test.holiday.BadHolidayCalendarFactory1");
        try {
            HolidayCalendarFactory.newInstance();
        }
        catch (HolidayCalendarException e) {
            System.clearProperty("jfin.HolidayCalendarFactory");
            return;
        }
        System.clearProperty("jfin.HolidayCalendarFactory");
        HolidayCalendarFactoryTest.fail((String)"Found holiday calendar factory, even though it is not an instance of HolidayCalendarFactory");
    }

    public void testHolidayCalendarFactoryNoDefaultConstructor() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.test.holiday.BadHolidayCalendarFactory2");
        try {
            HolidayCalendarFactory.newInstance();
        }
        catch (HolidayCalendarException e) {
            System.clearProperty("jfin.HolidayCalendarFactory");
            return;
        }
        System.clearProperty("jfin.HolidayCalendarFactory");
        HolidayCalendarFactoryTest.fail((String)"Found holiday calendar factory, even though it does not have a default constructor");
    }

    public void testHolidayCalendarFactoryPrivateConstructor() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.test.holiday.BadHolidayCalendarFactory3");
        try {
            HolidayCalendarFactory.newInstance();
        }
        catch (HolidayCalendarException e) {
            System.clearProperty("jfin.HolidayCalendarFactory");
            return;
        }
        System.clearProperty("jfin.HolidayCalendarFactory");
        HolidayCalendarFactoryTest.fail((String)"Found holiday calendar factory, even though its default constructor is private");
    }

    public void testGetSingleHolidayCalendarFromArrayMethod() {
        HolidayCalendarFactory testHolidayCalendarFactory = HolidayCalendarFactory.newInstance("org.jfin.date.test.holiday.HolidayCalendarFactoryTestImpl");
        HolidayCalendar LnB = testHolidayCalendarFactory.getHolidayCalendar(new String[]{"LnB"});
        HolidayCalendarFactoryTest.assertTrue((boolean)(LnB instanceof LondonHolidayCalendar));
    }

    public void testGetUnknownHolidayCalendar() {
        try {
            HolidayCalendarFactory.newInstance().getHolidayCalendar("FAIL");
        }
        catch (HolidayCalendarException e) {
            return;
        }
        HolidayCalendarFactoryTest.fail((String)"HolidayCalendarFactory failed to return an exception even though an unknown HolidayCalendar was provided.");
    }
}

