/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.daycount.defaultimpl;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.date.Period;
import org.jfin.date.daycount.defaultimpl.ISDAActualActual;
import org.jfin.date.util.ISDADateFormat;

public class ISDActualActualTest
extends TestCase {
    public void testGetPeriods() throws ParseException {
        ISDAActualActual isda = new ISDAActualActual();
        Calendar start = ISDADateFormat.parse("2005/10/5");
        Calendar end = ISDADateFormat.parse("2007/3/10");
        List<Period> periods = isda.getPeriods(start, end);
        ISDActualActualTest.assertEquals((int)3, (int)periods.size());
        Period period1 = periods.get(0);
        Period period2 = periods.get(1);
        Period period3 = periods.get(2);
        ISDActualActualTest.assertEquals((String)"2005/10/5", (String)ISDADateFormat.format(period1.getStartCalendar()));
        ISDActualActualTest.assertEquals((String)"2006/1/1", (String)ISDADateFormat.format(period1.getEndCalendar()));
        ISDActualActualTest.assertEquals((String)"2006/1/1", (String)ISDADateFormat.format(period2.getStartCalendar()));
        ISDActualActualTest.assertEquals((String)"2007/1/1", (String)ISDADateFormat.format(period2.getEndCalendar()));
        ISDActualActualTest.assertEquals((String)"2007/1/1", (String)ISDADateFormat.format(period3.getStartCalendar()));
        ISDActualActualTest.assertEquals((String)"2007/3/10", (String)ISDADateFormat.format(period3.getEndCalendar()));
    }

    public void testNumerators() throws ParseException {
        ISDAActualActual isda = new ISDAActualActual();
        Calendar start = ISDADateFormat.parse("2003/11/1");
        Calendar end = ISDADateFormat.parse("2004/5/1");
        int[] numerators = isda.getNumerators(isda.getPeriods(start, end));
        ISDActualActualTest.assertEquals((int)61, (int)numerators[0]);
        ISDActualActualTest.assertEquals((int)121, (int)numerators[1]);
    }

    public void testDenominators() throws ParseException {
        ISDAActualActual isda = new ISDAActualActual();
        Calendar start = ISDADateFormat.parse("2003/11/1");
        Calendar end = ISDADateFormat.parse("2004/5/1");
        int[] denominators = isda.getDenominators(isda.getPeriods(start, end));
        ISDActualActualTest.assertEquals((int)365, (int)denominators[0]);
        ISDActualActualTest.assertEquals((int)366, (int)denominators[1]);
    }

    public void testAmounts() throws ParseException {
        ISDAActualActual isda = new ISDAActualActual();
        Calendar start = ISDADateFormat.parse("2003/11/1");
        Calendar end = ISDADateFormat.parse("2004/5/1");
        double fraction = isda.calculateDaycountFraction(start, end);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        ISDActualActualTest.assertEquals((String)"497.72", (String)nf.format(fraction * 1000.0));
    }
}

