/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.daycount.defaultimpl;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.Period;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;

public class DaycountSanityCheckTest
extends TestCase {
    DaycountCalculatorFactory factory = DaycountCalculatorFactory.newInstance();
    HolidayCalendar holidayCalendar = HolidayCalendarFactory.newInstance().getHolidayCalendar("WE");
    Period testPeriod1 = new Period(new GregorianCalendar(2005, 0, 1), new GregorianCalendar(2005, 3, 1));
    double minValue1 = 0.24;
    double maxValue1 = 0.26;
    Period testPeriod2 = new Period(new GregorianCalendar(2005, 3, 1), new GregorianCalendar(2005, 0, 1));
    double minValue2 = 0.24;
    double maxValue2 = 0.26;
    Period testPeriod3 = new Period(new GregorianCalendar(2005, 0, 1), new GregorianCalendar(2005, 0, 1));
    double minValue3 = 0.0;
    double maxValue3 = 0.0;

    public void testActual360() {
        this.check(this.factory.getActual360());
    }

    public void testActual365Fixed() {
        this.check(this.factory.getActual365Fixed());
    }

    public void testActual366() {
        this.check(this.factory.getActual366());
    }

    public void testAFBActualActual() {
        this.check(this.factory.getAFBActualActual());
    }

    public void testBusiness252() {
        this.check(this.factory.getBusiness252(this.holidayCalendar));
    }

    public void testEU30360() {
        this.check(this.factory.getEU30360());
    }

    public void testISDAActualActual() {
        this.check(this.factory.getISDAActualActual());
    }

    public void testISMActualActual() {
        this.check(this.factory.getISMAActualActual());
    }

    public void testIT30360() {
        this.check(this.factory.getIT30360());
    }

    public void testUS30360() {
        this.check(this.factory.getUS30360());
    }

    public void check(DaycountCalculator calculator) {
        DaycountSanityCheckTest.assertTrue((boolean)this.daycountBetween(this.testPeriod1, calculator, this.minValue1, this.maxValue1));
        DaycountSanityCheckTest.assertTrue((boolean)this.daycountBetween(this.testPeriod2, calculator, this.minValue2, this.maxValue2));
        DaycountSanityCheckTest.assertTrue((boolean)this.daycountBetween(this.testPeriod3, calculator, this.minValue3, this.maxValue3));
    }

    public boolean daycountBetween(Period period, DaycountCalculator calculator, double min, double max) {
        double val = calculator.calculateDaycountFraction(period);
        return val >= min && val <= max;
    }
}

