/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;
import org.jfin.date.holiday.financialcalendarimpl.HolidayFileEntry;
import org.jfin.date.holiday.financialcalendarimpl.InfoFile;

public class HolidayFile {
    private TreeMap<String, HolidayFileEntry> entries = new TreeMap();

    public HolidayFile() {
    }

    public HolidayFile(File f, InfoFile infoFile) throws IOException {
        this();
        this.load(f, infoFile);
    }

    public void load(File f, InfoFile infoFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            HolidayFileEntry holidayFileEntry = new HolidayFileEntry(line, infoFile);
            this.entries.put(holidayFileEntry.getReference(), holidayFileEntry);
        }
    }

    public void addEntry(HolidayFileEntry entry) {
        this.entries.put(entry.getReference(), entry);
    }

    public HolidayFileEntry getEntryByReference(String code) {
        return this.entries.get(code);
    }
}

