/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.daycount.defaultimpl.AFBActualActual;
import org.jfin.date.daycount.defaultimpl.Actual360;
import org.jfin.date.daycount.defaultimpl.Actual365Fixed;
import org.jfin.date.daycount.defaultimpl.Actual366;
import org.jfin.date.daycount.defaultimpl.Business252;
import org.jfin.date.daycount.defaultimpl.EU30360;
import org.jfin.date.daycount.defaultimpl.ISDAActualActual;
import org.jfin.date.daycount.defaultimpl.ISMAActualActual;
import org.jfin.date.daycount.defaultimpl.IT30360;
import org.jfin.date.daycount.defaultimpl.US30360;
import org.jfin.date.holiday.HolidayCalendar;

public class DaycountCalculatorFactoryImpl
extends DaycountCalculatorFactory {
    @Override
    public DaycountCalculator getISDAActualActual() {
        return new ISDAActualActual();
    }

    @Override
    public DaycountCalculator getISMAActualActual() {
        return new ISMAActualActual();
    }

    @Override
    public DaycountCalculator getAFBActualActual() {
        return new AFBActualActual();
    }

    @Override
    public DaycountCalculator getUS30360() {
        return new US30360();
    }

    @Override
    public DaycountCalculator getEU30360() {
        return new EU30360();
    }

    @Override
    public DaycountCalculator getIT30360() {
        return new IT30360();
    }

    @Override
    public DaycountCalculator getActual360() {
        return new Actual360();
    }

    @Override
    public DaycountCalculator getActual365Fixed() {
        return new Actual365Fixed();
    }

    @Override
    public DaycountCalculator getActual366() {
        return new Actual366();
    }

    @Override
    public DaycountCalculator getBusiness252(HolidayCalendar holidayCalendar) {
        return new Business252(holidayCalendar);
    }

    @Override
    public String[] getAvailableDaycountCalculators() {
        return new String[]{"ISDAActualActual", "ISMAActualActual", "AFBActualActual", "US30360", "EU30360", "IT30360", "Actual360", "Actual365Fixed", "Actual366"};
    }
}

