/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.StubType;
import org.jfin.date.Tenor;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleGenerator {
    private static Logger logger = Logger.getLogger("org.jfin.date.ScheduleGenerator");

    public static List<Period> generateSchedule(Calendar startDate, String maturityString, Frequency frequency, StubType stubType) throws ScheduleException, ParseException {
        return ScheduleGenerator.generateSchedule(startDate, maturityString, frequency, stubType, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, String maturityString, Frequency frequency, StubType stubType, int maxPeriods) throws ScheduleException, ParseException {
        Tenor tenor = new Tenor(maturityString);
        return ScheduleGenerator.generateSchedule(startDate, tenor, frequency, stubType, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, String maturityString, Frequency frequency, StubType stubType, Period prototype) throws ScheduleException, ParseException {
        return ScheduleGenerator.generateSchedule(startDate, maturityString, frequency, stubType, prototype, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, String maturityString, Frequency frequency, StubType stubType, Period prototype, int maxPeriods) throws ScheduleException, ParseException {
        Tenor tenor = new Tenor(maturityString);
        return ScheduleGenerator.generateSchedule(startDate, tenor, frequency, stubType, prototype, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Tenor maturity, Frequency frequency, StubType stubType) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, maturity, frequency, stubType, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Tenor maturity, Frequency frequency, StubType stubType, int maxPeriods) throws ScheduleException {
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(maturity.getCalendarUnit(), maturity.getAmount());
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency, stubType, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Tenor maturity, Frequency frequency, StubType stubType, Period prototype) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, maturity, frequency, stubType, prototype, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Tenor maturity, Frequency frequency, StubType stubType, Period prototype, int maxPeriods) throws ScheduleException {
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(maturity.getCalendarUnit(), maturity.getAmount());
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency, stubType, prototype, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, Frequency frequency, StubType stubType) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency, stubType, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, Frequency frequency, StubType stubType, int maxPeriods) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency.getPeriodAmount(), frequency.getPeriodUnit(), stubType, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, Frequency frequency, StubType stubType, Period prototype) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency, stubType, prototype, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, Frequency frequency, StubType stubType, Period prototype, int maxPeriods) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequency.getPeriodAmount(), frequency.getPeriodUnit(), stubType, prototype, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequencyAmount, frequencyUnit, stubType, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType, int maxPeriods) throws ScheduleException {
        Period prototype = new Period();
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequencyAmount, frequencyUnit, stubType, prototype, maxPeriods);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType, Period prototype) throws ScheduleException {
        return ScheduleGenerator.generateSchedule(startDate, endDate, frequencyAmount, frequencyUnit, stubType, prototype, -1);
    }

    public static List<Period> generateSchedule(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType, Period prototype, int maxPeriods) throws ScheduleException {
        Calendar cleanEndDate = ScheduleGenerator.copyAndReset(endDate);
        Calendar cleanStartDate = ScheduleGenerator.copyAndReset(startDate);
        int periodCount = 0;
        logger.fine("Generating " + stubType.name() + " " + frequencyAmount + ":" + ScheduleGenerator.getCalendarUnitDescriptor(frequencyUnit) + " schedule between " + ISDADateFormat.format(startDate) + " and " + ISDADateFormat.format(endDate));
        if (stubType == StubType.SHORT_LAST || stubType == StubType.NONE) {
            ArrayList<Period> schedule = new ArrayList<Period>();
            Calendar holdDate = ScheduleGenerator.copyAndReset(startDate);
            int count = 1;
            while (holdDate.before(cleanEndDate)) {
                Calendar nextDate = ScheduleGenerator.copyAndReset(startDate);
                nextDate.add(frequencyUnit, frequencyAmount * count);
                ++count;
                Calendar notionalStartDate = null;
                Calendar notionalEndDate = null;
                if (nextDate.after(cleanEndDate)) {
                    if (stubType == StubType.SHORT_LAST) {
                        notionalStartDate = holdDate;
                        notionalEndDate = nextDate;
                        nextDate = cleanEndDate;
                    } else {
                        throw new ScheduleException("StubType.NONE used when periods do not fit start and end date");
                    }
                }
                Period toAdd = prototype.clone();
                toAdd.setStartCalendar(holdDate);
                toAdd.setEndCalendar(nextDate);
                toAdd.setReferenceStartCalendar(notionalStartDate);
                toAdd.setReferenceEndCalendar(notionalEndDate);
                schedule.add(toAdd);
                holdDate = nextDate;
                if (maxPeriods <= 0 || ++periodCount <= maxPeriods) continue;
                throw new ScheduleException("Maximum number of periods (" + maxPeriods + ") exceeded.");
            }
            return schedule;
        }
        if (stubType == StubType.SHORT_FIRST) {
            ArrayList<Period> schedule = new ArrayList<Period>();
            Calendar holdDate = ScheduleGenerator.copyAndReset(endDate);
            int count = 1;
            while (holdDate.after(cleanStartDate)) {
                Calendar nextDate = ScheduleGenerator.copyAndReset(endDate);
                nextDate.add(frequencyUnit, -1 * frequencyAmount * count);
                ++count;
                Calendar notionalStartDate = null;
                Calendar notionalEndDate = null;
                if (nextDate.before(cleanStartDate)) {
                    notionalStartDate = nextDate;
                    notionalEndDate = holdDate;
                    nextDate = cleanStartDate;
                }
                Period toAdd = prototype.clone();
                toAdd.setStartCalendar(nextDate);
                toAdd.setEndCalendar(holdDate);
                toAdd.setReferenceStartCalendar(notionalStartDate);
                toAdd.setReferenceEndCalendar(notionalEndDate);
                schedule.add(0, toAdd);
                holdDate = nextDate;
                if (maxPeriods <= 0 || ++periodCount <= maxPeriods) continue;
                throw new ScheduleException("Maximum number of periods (" + maxPeriods + ") exceeded.");
            }
            return schedule;
        }
        if (stubType == StubType.LONG_LAST) {
            ArrayList<Period> schedule = new ArrayList<Period>();
            Calendar holdDate = ScheduleGenerator.copyAndReset(startDate);
            int count = 1;
            while (holdDate.before(cleanEndDate)) {
                Calendar nextDate = ScheduleGenerator.copyAndReset(startDate);
                nextDate.add(frequencyUnit, frequencyAmount * count);
                Calendar nextDate2 = ScheduleGenerator.copyAndReset(startDate);
                nextDate2.add(frequencyUnit, frequencyAmount * (count + 1));
                ++count;
                Calendar notionalStartDate = null;
                Calendar notionalEndDate = null;
                if (nextDate2.after(cleanEndDate)) {
                    notionalStartDate = nextDate;
                    notionalEndDate = nextDate2;
                    nextDate = cleanEndDate;
                }
                Period toAdd = prototype.clone();
                toAdd.setStartCalendar(holdDate);
                toAdd.setEndCalendar(nextDate);
                toAdd.setReferenceStartCalendar(notionalStartDate);
                toAdd.setReferenceEndCalendar(notionalEndDate);
                schedule.add(toAdd);
                holdDate = nextDate;
                if (maxPeriods <= 0 || ++periodCount <= maxPeriods) continue;
                throw new ScheduleException("Maximum number of periods (" + maxPeriods + ") exceeded.");
            }
            return schedule;
        }
        if (stubType == StubType.LONG_FIRST) {
            ArrayList<Period> schedule = new ArrayList<Period>();
            Calendar holdDate = ScheduleGenerator.copyAndReset(endDate);
            int count = 1;
            while (holdDate.after(cleanStartDate)) {
                Calendar nextDate = ScheduleGenerator.copyAndReset(endDate);
                nextDate.add(frequencyUnit, -1 * frequencyAmount * count);
                Calendar nextDate2 = ScheduleGenerator.copyAndReset(endDate);
                nextDate2.add(frequencyUnit, -1 * frequencyAmount * (count + 1));
                ++count;
                Calendar notionalStartDate = null;
                Calendar notionalEndDate = null;
                if (nextDate2.before(cleanStartDate)) {
                    notionalStartDate = nextDate2;
                    notionalEndDate = nextDate;
                    nextDate = cleanStartDate;
                }
                Period toAdd = prototype.clone();
                toAdd.setStartCalendar(nextDate);
                toAdd.setEndCalendar(holdDate);
                toAdd.setReferenceStartCalendar(notionalStartDate);
                toAdd.setReferenceEndCalendar(notionalEndDate);
                schedule.add(0, toAdd);
                holdDate = nextDate;
                if (maxPeriods <= 0 || ++periodCount <= maxPeriods) continue;
                throw new ScheduleException("Maximum number of periods (" + maxPeriods + ") exceeded.");
            }
            return schedule;
        }
        throw new ScheduleException("Unsupported stub type " + (Object)((Object)stubType));
    }

    public static Calendar copyAndReset(Calendar calendar) {
        Calendar copy = (Calendar)calendar.clone();
        copy.set(11, 0);
        copy.set(12, 0);
        copy.set(13, 0);
        copy.set(14, 0);
        return copy;
    }

    public static String getCalendarUnitDescriptor(int calendarUnit) {
        switch (calendarUnit) {
            case 5: {
                return "DAY";
            }
            case 7: {
                return "DAY";
            }
            case 6: {
                return "DAY";
            }
            case 2: {
                return "MONTH";
            }
            case 1: {
                return "YEAR";
            }
        }
        return "UNKNOWN";
    }
}

