/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date;

import java.util.Calendar;
import org.jfin.date.util.ISDADateFormat;

public class Period
implements Comparable {
    private Calendar startCalendar;
    private Calendar endCalendar;
    private Calendar referenceStartCalendar;
    private Calendar referenceEndCalendar;

    public Period() {
    }

    public Period(Period toCopy) {
        this.startCalendar = toCopy.startCalendar;
        this.endCalendar = toCopy.endCalendar;
        this.referenceStartCalendar = toCopy.referenceStartCalendar;
        this.referenceEndCalendar = toCopy.referenceEndCalendar;
    }

    public Period clone() {
        return new Period(this);
    }

    public Period(Calendar startCalendar, Calendar endCalendar) {
        this.startCalendar = startCalendar;
        this.endCalendar = endCalendar;
    }

    public Period(Calendar startCalendar, Calendar endCalendar, Calendar referenceStartCalendar, Calendar referenceEndCalendar) {
        this.startCalendar = startCalendar;
        this.endCalendar = endCalendar;
        this.referenceStartCalendar = referenceStartCalendar;
        this.referenceEndCalendar = referenceEndCalendar;
    }

    public Calendar getStartCalendar() {
        return this.startCalendar;
    }

    public void setStartCalendar(Calendar calendar) {
        this.startCalendar = calendar;
    }

    public Calendar getEndCalendar() {
        return this.endCalendar;
    }

    public void setEndCalendar(Calendar calendar) {
        this.endCalendar = calendar;
    }

    public Calendar getReferenceEndCalendar() {
        return this.referenceEndCalendar;
    }

    public void setReferenceEndCalendar(Calendar referenceEndCalendar) {
        this.referenceEndCalendar = referenceEndCalendar;
    }

    public Calendar getReferenceStartCalendar() {
        return this.referenceStartCalendar;
    }

    public void setReferenceStartCalendar(Calendar referenceStartCalendar) {
        this.referenceStartCalendar = referenceStartCalendar;
    }

    public String toString() {
        if (this.referenceStartCalendar == null || this.referenceEndCalendar == null) {
            return ISDADateFormat.format(this.startCalendar) + " - " + ISDADateFormat.format(this.endCalendar);
        }
        return ISDADateFormat.format(this.startCalendar) + " - " + ISDADateFormat.format(this.endCalendar) + "[" + ISDADateFormat.format(this.referenceStartCalendar) + " - " + ISDADateFormat.format(this.referenceEndCalendar) + "]";
    }

    private long getDoubleMidPoint() {
        return this.startCalendar.getTimeInMillis() + this.endCalendar.getTimeInMillis();
    }

    private long getDoubleMidPoint(Calendar calendar) {
        return 2L * calendar.getTimeInMillis();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof Period) {
            Period period = (Period)arg0;
            int retval = (int)((this.getDoubleMidPoint() - period.getDoubleMidPoint()) / 60000L);
            if (retval == 0) {
                return 0;
            }
            return retval / Math.abs(retval);
        }
        if (arg0 instanceof Calendar) {
            Calendar calendar = (Calendar)arg0;
            int retval = (int)((this.getDoubleMidPoint() - this.getDoubleMidPoint(calendar)) / 60000L);
            if (retval == 0) {
                return 0;
            }
            return retval / Math.abs(retval);
        }
        throw new RuntimeException("Cannot compare org.jfin.date.Period with an object of class " + arg0.getClass().getName());
    }
}

