/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.common;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

public class CSVFileFormatTokenizer {
    String[] tokens;
    int point;
    NumberFormat nf = NumberFormat.getNumberInstance();
    DateFormat df = DateFormat.getInstance();

    public CSVFileFormatTokenizer(String input) {
        this.initialise(input);
    }

    private String[] split(String in) {
        ArrayList<String> split = new ArrayList<String>();
        String hold = "";
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == ',') {
                split.add(hold);
                hold = "";
                continue;
            }
            hold = hold + c;
        }
        split.add(hold);
        String[] splitArray = new String[split.size()];
        for (int i = 0; i < split.size(); ++i) {
            splitArray[i] = (String)split.get(i);
        }
        return splitArray;
    }

    public void initialise(String input) {
        int i;
        String[] holdTokens = this.split(input);
        ArrayList<String> collectedTokens = new ArrayList<String>();
        String lastToken = null;
        boolean inQuotes = false;
        for (i = 0; i < holdTokens.length; ++i) {
            String currentToken = holdTokens[i];
            if (inQuotes) {
                if (currentToken.endsWith("\"")) {
                    lastToken = lastToken + "," + currentToken.substring(0, currentToken.length() - 1);
                    collectedTokens.add(lastToken);
                    inQuotes = false;
                    continue;
                }
                lastToken = lastToken + "," + currentToken;
                continue;
            }
            if (currentToken.startsWith("\"")) {
                if (currentToken.equals("\"")) {
                    lastToken = "";
                    inQuotes = true;
                    continue;
                }
                if (currentToken.endsWith("\"")) {
                    collectedTokens.add(currentToken.substring(1, currentToken.length() - 1));
                    continue;
                }
                lastToken = currentToken.substring(1);
                inQuotes = true;
                continue;
            }
            collectedTokens.add(currentToken);
        }
        this.tokens = new String[collectedTokens.size()];
        for (i = 0; i < collectedTokens.size(); ++i) {
            this.tokens[i] = ((String)collectedTokens.get(i)).replaceAll("\"\"", "\"");
        }
        this.point = 0;
    }

    public boolean hasNext() {
        return this.point < this.tokens.length;
    }

    public String next() {
        return this.tokens[this.point++];
    }

    public static String[] getTokens(String line) {
        CSVFileFormatTokenizer tokenizer = new CSVFileFormatTokenizer(line);
        return tokenizer.getTokens();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public Number nextNumber() throws ParseException {
        return this.nextNumber(this.nf);
    }

    public Number nextNumber(NumberFormat numberFormat) throws ParseException {
        return numberFormat.parse(this.next());
    }

    public double nextDouble() throws ParseException {
        return this.nextDouble(this.nf);
    }

    public double nextDouble(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).doubleValue();
    }

    public int nextInt() throws ParseException {
        return this.nextInt(this.nf);
    }

    public int nextInt(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).intValue();
    }

    public long nextLong() throws ParseException {
        return this.nextLong(this.nf);
    }

    public long nextLong(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).longValue();
    }

    public byte nextByte() throws ParseException {
        return this.nextByte(this.nf);
    }

    public byte nextByte(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).byteValue();
    }

    public short nextShort() throws ParseException {
        return this.nextShort(this.nf);
    }

    public short nextShort(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).shortValue();
    }

    public float nextFloat() throws ParseException {
        return this.nextFloat(this.nf);
    }

    public float nextFloat(NumberFormat numberFormat) throws ParseException {
        return this.nextNumber(numberFormat).floatValue();
    }

    public Date nextDate() throws ParseException {
        return this.nextDate(this.df);
    }

    public Date nextDate(DateFormat dateFormat) throws ParseException {
        return dateFormat.parse(this.next());
    }
}

