/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.Schedule;
import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.impl.NoStubScheduleGenerator;
import junit.framework.TestCase;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.Years;

public class NoStubScheduleGeneratorTest
extends TestCase {
    public void testGenerate1() throws ScheduleException {
        NoStubScheduleGenerator generator = new NoStubScheduleGenerator();
        Schedule schedule = generator.generate(new LocalDate(2006, 3, 28), new LocalDate(2011, 3, 28), Years.ONE);
        NoStubScheduleGeneratorTest.assertEquals((int)5, (int)schedule.size());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 3, 28), (Object)schedule.get(0).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2007, 3, 28), (Object)schedule.get(0).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2007, 3, 28), (Object)schedule.get(1).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2008, 3, 28), (Object)schedule.get(1).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2008, 3, 28), (Object)schedule.get(2).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2009, 3, 28), (Object)schedule.get(2).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2009, 3, 28), (Object)schedule.get(3).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2010, 3, 28), (Object)schedule.get(3).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2010, 3, 28), (Object)schedule.get(4).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2011, 3, 28), (Object)schedule.get(4).getEnd());
    }

    public void testGenerate2() throws ScheduleException {
        NoStubScheduleGenerator generator = new NoStubScheduleGenerator();
        Schedule schedule = generator.generate(new LocalDate(2006, 3, 28), new LocalDate(2007, 3, 28), Months.THREE);
        NoStubScheduleGeneratorTest.assertEquals((int)4, (int)schedule.size());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 3, 28), (Object)schedule.get(0).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 6, 28), (Object)schedule.get(0).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 6, 28), (Object)schedule.get(1).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 9, 28), (Object)schedule.get(1).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 9, 28), (Object)schedule.get(2).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 12, 28), (Object)schedule.get(2).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 12, 28), (Object)schedule.get(3).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2007, 3, 28), (Object)schedule.get(3).getEnd());
    }

    public void testGenerate3() throws ScheduleException {
        NoStubScheduleGenerator generator = new NoStubScheduleGenerator();
        Schedule schedule = generator.generate(new LocalDate(2006, 3, 31), new LocalDate(2007, 3, 31), Months.THREE);
        NoStubScheduleGeneratorTest.assertEquals((int)4, (int)schedule.size());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 3, 31), (Object)schedule.get(0).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 6, 30), (Object)schedule.get(0).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 6, 30), (Object)schedule.get(1).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 9, 30), (Object)schedule.get(1).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 9, 30), (Object)schedule.get(2).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 12, 31), (Object)schedule.get(2).getEnd());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2006, 12, 31), (Object)schedule.get(3).getStart());
        NoStubScheduleGeneratorTest.assertEquals((Object)new LocalDate(2007, 3, 31), (Object)schedule.get(3).getEnd());
    }

    public void testGeneratorFail1() {
        NoStubScheduleGenerator generator = new NoStubScheduleGenerator(3);
        try {
            generator.generate(new LocalDate(2006, 3, 31), new LocalDate(2007, 3, 31), Months.THREE);
            NoStubScheduleGeneratorTest.fail((String)"Should have thrown an exception when creating a schedule that was too long");
        }
        catch (ScheduleException scheduleException) {
            // empty catch block
        }
    }

    public void testGeneratorFail2() {
        NoStubScheduleGenerator generator = new NoStubScheduleGenerator();
        try {
            generator.generate(new LocalDate(2006, 3, 31), new LocalDate(2007, 3, 20), Months.THREE);
            NoStubScheduleGeneratorTest.fail((String)"Should have thrown an exception when creating a schedule with an uneven last period");
        }
        catch (ScheduleException scheduleException) {
            // empty catch block
        }
    }
}

