/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.impl.ScheduleGenerator;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;

public abstract class AbstractBaseScheduleGenerator
implements ScheduleGenerator {
    protected int maxPeriods;

    protected AbstractBaseScheduleGenerator(int maxPeriods) {
        this.maxPeriods = maxPeriods;
    }

    protected ReadablePeriod multiplyPeriod(ReadablePeriod frequency, int periodCount) throws ScheduleException {
        if (frequency instanceof Months) {
            return Months.months(frequency.getValue(0) * periodCount);
        }
        if (frequency instanceof Days) {
            return Days.days(frequency.getValue(0) * periodCount);
        }
        if (frequency instanceof Weeks) {
            return Weeks.weeks(frequency.getValue(0) * periodCount);
        }
        if (frequency instanceof Years) {
            return Years.years(frequency.getValue(0) * periodCount);
        }
        throw new ScheduleException("Unknown frequency type: " + frequency);
    }
}

