/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl.calculator;

import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;

public class IT30360DaycountCalculator
implements DaycountCalculator {
    @Override
    public double calculateDaycountFraction(SchedulePeriod period, HolidayCalendar calendar) {
        if (period.getStart().equals(period.getEnd())) {
            return 0.0;
        }
        int dayOfMonth1 = period.getStart().getDayOfMonth();
        int dayOfMonth2 = period.getEnd().getDayOfMonth();
        int month1 = period.getStart().getMonthOfYear();
        int month2 = period.getEnd().getMonthOfYear();
        int year1 = period.getStart().getYear();
        int year2 = period.getEnd().getYear();
        if (month1 == 2 && dayOfMonth1 > 27) {
            dayOfMonth1 = 30;
        }
        if (month2 == 2 && dayOfMonth2 > 27) {
            dayOfMonth2 = 30;
        }
        return (double)(year2 - year1) + (double)(30 * (month2 - month1 - 1) + Math.max(0, 30 - dayOfMonth1) + Math.min(30, dayOfMonth2)) / 360.0;
    }
}

