/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontCache
implements Serializable {
    private static final long serialVersionUID = 605232520271754719L;
    private static final String FOP_USER_DIR = ".fop";
    private static final String DEFAULT_CACHE_FILENAME = "fop-fonts.cache";
    private transient boolean changed = false;
    private final boolean[] changeLock = new boolean[1];
    private Map<String, CachedFontFile> fontfileMap = null;
    private Map<String, Long> failedFontMap = null;

    private static File getUserHome() {
        return FontCache.toDirectory(System.getProperty("user.home"));
    }

    private static File getTempDirectory() {
        return FontCache.toDirectory(System.getProperty("java.io.tmpdir"));
    }

    private static File toDirectory(String path) {
        File dir;
        if (path != null && (dir = new File(path)).exists()) {
            return dir;
        }
        return null;
    }

    public static File getDefaultCacheFile(boolean forWriting) {
        File userHome = FontCache.getUserHome();
        if (userHome != null) {
            File fopUserDir = new File(userHome, FOP_USER_DIR);
            if (forWriting) {
                boolean writable = fopUserDir.canWrite();
                if (!fopUserDir.exists()) {
                    writable = fopUserDir.mkdir();
                }
                if (!writable) {
                    userHome = FontCache.getTempDirectory();
                    fopUserDir = new File(userHome, FOP_USER_DIR);
                    fopUserDir.mkdir();
                }
            }
            return new File(fopUserDir, DEFAULT_CACHE_FILENAME);
        }
        return new File(FOP_USER_DIR);
    }

    public static FontCache load() {
        return FontCache.loadFrom(FontCache.getDefaultCacheFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontCache loadFrom(File cacheFile) {
        block9: {
            if (cacheFile.exists()) {
                FontCache fontCache;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(cacheFile));
                ObjectInputStream oin = new ObjectInputStream(in);
                try {
                    fontCache = (FontCache)oin.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(oin);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        break block9;
                    }
                    catch (IOException ioe) {
                        try {
                            cacheFile.delete();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
                IOUtils.closeQuietly(oin);
                return fontCache;
            }
        }
        return null;
    }

    public void save() throws FOPException {
        this.saveTo(FontCache.getDefaultCacheFile(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File cacheFile) throws FOPException {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.changed) {
                try {
                    OutputStream out = new FileOutputStream(cacheFile);
                    out = new BufferedOutputStream(out);
                    ObjectOutputStream oout = new ObjectOutputStream(out);
                    try {
                        oout.writeObject(this);
                    }
                    finally {
                        IOUtils.closeQuietly(oout);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.changed = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static String getCacheKey(EmbedFontInfo fontInfo) {
        if (fontInfo != null) {
            String embedFile = fontInfo.getEmbedFile();
            String metricsFile = fontInfo.getMetricsFile();
            return embedFile != null ? embedFile : metricsFile;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean containsFont(String embedUrl) {
        return embedUrl != null && this.getFontFileMap().containsKey(embedUrl);
    }

    public boolean containsFont(EmbedFontInfo fontInfo) {
        return fontInfo != null && this.getFontFileMap().containsKey(FontCache.getCacheKey(fontInfo));
    }

    public static File getFileFromUrls(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String urlStr = urls[i];
            if (urlStr == null) continue;
            File fontFile = null;
            if (urlStr.startsWith("file:")) {
                try {
                    URL url = new URL(urlStr);
                    fontFile = FileUtils.toFile(url);
                }
                catch (MalformedURLException mfue) {
                    // empty catch block
                }
            }
            if (fontFile == null) {
                fontFile = new File(urlStr);
            }
            if (!fontFile.exists() || !fontFile.canRead()) continue;
            return fontFile;
        }
        return null;
    }

    private Map<String, CachedFontFile> getFontFileMap() {
        if (this.fontfileMap == null) {
            this.fontfileMap = new HashMap<String, CachedFontFile>();
        }
        return this.fontfileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFont(EmbedFontInfo fontInfo) {
        String cacheKey = FontCache.getCacheKey(fontInfo);
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(cacheKey)) {
                CachedFontFile cachedFontFile = this.getFontFileMap().get(cacheKey);
                if (!cachedFontFile.containsFont(fontInfo)) {
                    cachedFontFile.put(fontInfo);
                }
            } else {
                File fontFile = FontCache.getFileFromUrls(new String[]{fontInfo.getEmbedFile(), fontInfo.getMetricsFile()});
                long lastModified = fontFile != null ? fontFile.lastModified() : -1L;
                CachedFontFile cachedFontFile = new CachedFontFile(lastModified);
                cachedFontFile.put(fontInfo);
                this.getFontFileMap().put(cacheKey, cachedFontFile);
                this.changed = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public CachedFontFile getFontFile(String embedUrl) {
        return this.containsFont(embedUrl) ? this.getFontFileMap().get(embedUrl) : null;
    }

    public EmbedFontInfo[] getFontInfos(String embedUrl, long lastModified) {
        CachedFontFile cff = this.getFontFile(embedUrl);
        if (cff.lastModified() == lastModified) {
            return cff.getEmbedFontInfos();
        }
        this.removeFont(embedUrl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFont(String embedUrl) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(embedUrl)) {
                this.getFontFileMap().remove(embedUrl);
                this.changed = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFont(String embedUrl, long lastModified) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.getFailedFontMap().containsKey(embedUrl)) {
                long failedLastModified = this.getFailedFontMap().get(embedUrl);
                if (lastModified != failedLastModified) {
                    this.getFailedFontMap().remove(embedUrl);
                    this.changed = true;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedFont(String embedUrl, long lastModified) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (!this.getFailedFontMap().containsKey(embedUrl)) {
                this.getFailedFontMap().put(embedUrl, new Long(lastModified));
                this.changed = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private Map<String, Long> getFailedFontMap() {
        if (this.failedFontMap == null) {
            this.failedFontMap = new HashMap<String, Long>();
        }
        return this.failedFontMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            this.fontfileMap = null;
            this.failedFontMap = null;
            this.changed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) {
        long l;
        URLConnection conn = url.openConnection();
        try {
            l = conn.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly(conn.getInputStream());
                throw throwable;
            }
            catch (IOException e) {
                return 0L;
            }
        }
        IOUtils.closeQuietly(conn.getInputStream());
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedFontFile
    implements Serializable {
        private static final long serialVersionUID = 4524237324330578883L;
        private long lastModified = -1L;
        private Map<String, EmbedFontInfo> filefontsMap = null;

        public CachedFontFile(long lastModified) {
            this.setLastModified(lastModified);
        }

        private Map<String, EmbedFontInfo> getFileFontsMap() {
            if (this.filefontsMap == null) {
                this.filefontsMap = new HashMap<String, EmbedFontInfo>();
            }
            return this.filefontsMap;
        }

        void put(EmbedFontInfo efi) {
            this.getFileFontsMap().put(efi.getPostScriptName(), efi);
        }

        public boolean containsFont(EmbedFontInfo efi) {
            return efi.getPostScriptName() != null && this.getFileFontsMap().containsKey(efi.getPostScriptName());
        }

        public EmbedFontInfo[] getEmbedFontInfos() {
            return this.getFileFontsMap().values().toArray(new EmbedFontInfo[this.getFileFontsMap().size()]);
        }

        public long lastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return super.toString() + ", lastModified=" + this.lastModified;
        }
    }
}

