/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.matrix.FormerFactory;
import hep.aida.tfloat.bin.DynamicFloatBin1D;
import hep.aida.tfloat.bin.FloatBinFunction1D;

public class FloatBinFunctions1D {
    public static final FloatBinFunctions1D functions = new FloatBinFunctions1D();
    public static final FloatBinFunction1D max = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.max();
        }

        @Override
        public final String name() {
            return "Max";
        }
    };
    public static final FloatBinFunction1D mean = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.mean();
        }

        @Override
        public final String name() {
            return "Mean";
        }
    };
    public static final FloatBinFunction1D median = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.median();
        }

        @Override
        public final String name() {
            return "Median";
        }
    };
    public static final FloatBinFunction1D min = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.min();
        }

        @Override
        public final String name() {
            return "Min";
        }
    };
    public static final FloatBinFunction1D rms = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.rms();
        }

        @Override
        public final String name() {
            return "RMS";
        }
    };
    public static final FloatBinFunction1D size = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.size();
        }

        @Override
        public final String name() {
            return "Size";
        }
    };
    public static final FloatBinFunction1D stdDev = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.standardDeviation();
        }

        @Override
        public final String name() {
            return "StdDev";
        }
    };
    public static final FloatBinFunction1D sum = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.sum();
        }

        @Override
        public final String name() {
            return "Sum";
        }
    };
    public static final FloatBinFunction1D sumLog = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.sumOfLogarithms();
        }

        @Override
        public final String name() {
            return "SumLog";
        }
    };
    public static final FloatBinFunction1D geometricMean = new FloatBinFunction1D(){

        @Override
        public final float apply(DynamicFloatBin1D bin) {
            return bin.geometricMean();
        }

        @Override
        public final String name() {
            return "GeomMean";
        }
    };

    protected FloatBinFunctions1D() {
    }

    public static FloatBinFunction1D quantile(final float percentage) {
        return new FloatBinFunction1D(){

            @Override
            public final float apply(DynamicFloatBin1D bin) {
                return bin.quantile(percentage);
            }

            @Override
            public final String name() {
                return new FormerFactory().create("%1.2G").form(percentage * 100.0f) + "% Q.";
            }
        };
    }
}

