/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.ref.DoubleAbstractHistogram3D;
import hep.aida.tdouble.ref.DoubleFixedAxis;
import hep.aida.tdouble.ref.DoubleHistogram2D;
import hep.aida.tdouble.ref.DoubleVariableAxis;

public class DoubleHistogram3D
extends DoubleAbstractHistogram3D
implements DoubleIHistogram3D {
    private static final long serialVersionUID = 1L;
    private double[][][] heights;
    private double[][][] errors;
    private int[][][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;
    private double meanZ;
    private double rmsZ;

    public DoubleHistogram3D(String title, double[] xEdges, double[] yEdges, double[] zEdges) {
        this(title, new DoubleVariableAxis(xEdges), new DoubleVariableAxis(yEdges), new DoubleVariableAxis(zEdges));
    }

    public DoubleHistogram3D(String title, int xBins, double xMin, double xMax, int yBins, double yMin, double yMax, int zBins, double zMin, double zMax) {
        this(title, new DoubleFixedAxis(xBins, xMin, xMax), new DoubleFixedAxis(yBins, yMin, yMax), new DoubleFixedAxis(zBins, zMin, zMax));
    }

    public DoubleHistogram3D(String title, DoubleIAxis xAxis, DoubleIAxis yAxis, DoubleIAxis zAxis) {
        super(title);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        int xBins = xAxis.bins();
        int yBins = yAxis.bins();
        int zBins = zAxis.bins();
        this.entries = new int[xBins + 2][yBins + 2][zBins + 2];
        this.heights = new double[xBins + 2][yBins + 2][zBins + 2];
        this.errors = new double[xBins + 2][yBins + 2][zBins + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int indexX, int indexY, int indexZ) {
        return this.entries[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)];
    }

    @Override
    public double binError(int indexX, int indexY, int indexZ) {
        return Math.sqrt(this.errors[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)]);
    }

    @Override
    public double binHeight(int indexX, int indexY, int indexZ) {
        return this.heights[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double x, double y, double z) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int zBin = this.mapZ(this.zAxis.coordToIndex(z));
        int[] nArray = this.entries[xBin][yBin];
        int n = zBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin][yBin];
        int n2 = zBin;
        dArray[n2] = dArray[n2] + 1.0;
        double[] dArray2 = this.errors[xBin][yBin];
        int n3 = zBin;
        dArray2[n3] = dArray2[n3] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += x;
        this.rmsX += x;
        this.meanY += y;
        this.rmsY += y;
        this.meanZ += z;
        this.rmsZ += z;
    }

    @Override
    public void fill(double x, double y, double z, double weight) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int zBin = this.mapZ(this.zAxis.coordToIndex(z));
        int[] nArray = this.entries[xBin][yBin];
        int n = zBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin][yBin];
        int n2 = zBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.errors[xBin][yBin];
        int n3 = zBin;
        dArray2[n3] = dArray2[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.meanX += x * weight;
        this.rmsX += x * weight * weight;
        this.meanY += y * weight;
        this.rmsY += y * weight * weight;
        this.meanZ += z * weight;
        this.rmsZ += z * weight * weight;
    }

    @Override
    protected DoubleIHistogram2D internalSliceXY(String title, int indexZ1, int indexZ2) {
        if (indexZ2 < indexZ1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int xBins = this.xAxis.bins() + 2;
        int yBins = this.yAxis.bins() + 2;
        int[][] sliceEntries = new int[xBins][yBins];
        double[][] sliceHeights = new double[xBins][yBins];
        double[][] sliceErrors = new double[xBins][yBins];
        for (int i = 0; i < xBins; ++i) {
            for (int j = 0; j < yBins; ++j) {
                for (int k = indexZ1; k <= indexZ2; ++k) {
                    int[] nArray = sliceEntries[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    double[] dArray = sliceHeights[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.heights[i][j][k];
                    double[] dArray2 = sliceErrors[i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + this.errors[i][j][k];
                }
            }
        }
        DoubleHistogram2D result = new DoubleHistogram2D(title, this.xAxis, this.yAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    protected DoubleIHistogram2D internalSliceXZ(String title, int indexY1, int indexY2) {
        if (indexY2 < indexY1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int xBins = this.xAxis.bins() + 2;
        int zBins = this.zAxis.bins() + 2;
        int[][] sliceEntries = new int[xBins][zBins];
        double[][] sliceHeights = new double[xBins][zBins];
        double[][] sliceErrors = new double[xBins][zBins];
        for (int i = 0; i < xBins; ++i) {
            for (int j = indexY1; j <= indexY2; ++j) {
                int k = 0;
                while (i < zBins) {
                    int[] nArray = sliceEntries[i];
                    int n = k;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    double[] dArray = sliceHeights[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + this.heights[i][j][k];
                    double[] dArray2 = sliceErrors[i];
                    int n3 = k;
                    dArray2[n3] = dArray2[n3] + this.errors[i][j][k];
                    ++k;
                }
            }
        }
        DoubleHistogram2D result = new DoubleHistogram2D(title, this.xAxis, this.zAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    protected DoubleIHistogram2D internalSliceYZ(String title, int indexX1, int indexX2) {
        if (indexX2 < indexX1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int yBins = this.yAxis.bins() + 2;
        int zBins = this.zAxis.bins() + 2;
        int[][] sliceEntries = new int[yBins][zBins];
        double[][] sliceHeights = new double[yBins][zBins];
        double[][] sliceErrors = new double[yBins][zBins];
        for (int i = indexX1; i <= indexX2; ++i) {
            for (int j = 0; j < yBins; ++j) {
                for (int k = 0; k < zBins; ++k) {
                    int[] nArray = sliceEntries[j];
                    int n = k;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    double[] dArray = sliceHeights[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + this.heights[i][j][k];
                    double[] dArray2 = sliceErrors[j];
                    int n3 = k;
                    dArray2[n3] = dArray2[n3] + this.errors[i][j][k];
                }
            }
        }
        DoubleHistogram2D result = new DoubleHistogram2D(title, this.yAxis, this.zAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    @Override
    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    @Override
    public double meanZ() {
        return this.meanZ / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                int k = 0;
                while (j < this.entries[0][0].length) {
                    this.entries[i][j][k] = 0;
                    this.heights[i][j][k] = 0.0;
                    this.errors[i][j][k] = 0.0;
                    ++k;
                }
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.meanZ = 0.0;
        this.rmsZ = 0.0;
    }

    @Override
    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsZ() {
        return Math.sqrt(this.rmsZ / this.sumWeight - this.meanZ * this.meanZ / this.sumWeight / this.sumWeight);
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

