/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix1DProcedure;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class IntMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected IntMatrix2D() {
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < IntMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(IntMatrix2D.this.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f, final IntProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int elem = IntMatrix2D.this.getQuick(firstRow, 0);
                        int a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < IntMatrix2D.this.columns; ++c) {
                                elem = IntMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            int elem = IntMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                int elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public int aggregate(final IntMatrix2D other, final IntIntFunction aggr, final IntIntFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < IntMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(IntMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public IntMatrix2D assign(final IntFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, f.apply(IntMatrix2D.this.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure cond, final IntFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                int elem = IntMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                IntMatrix2D.this.setQuick(r, c, f.apply(elem));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    int elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, f.apply(elem));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure cond, final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                int elem = IntMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                IntMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    int elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * IntMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, values[idx++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx++]);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int[] currentRow = values[r];
                            if (currentRow.length != IntMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + IntMatrix2D.this.columns());
                            }
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, currentRow[c]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                int[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, currentRow[c]);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final IntMatrix2D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, other_loc.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, other_loc.getQuick(r, c));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntMatrix2D y, final IntIntFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                IntMatrix2D.this.setQuick(r, c, function.apply(IntMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntMatrix2D y, final IntIntFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(IntMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                if (IntMatrix2D.this.getQuick(r, c) == 0) continue;
                                ++cardinality;
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (this.getQuick(r, c) == 0) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public IntMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(int value) {
        return IntProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntMatrix2D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix2D)obj);
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                int a;
                                int value = IntMatrix2D.this.getQuick(r, c);
                                if (value == 0 || (a = function.apply(r, c, value)) == value) continue;
                                IntMatrix2D.this.setQuick(r, c, a);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    int a;
                    int value = this.getQuick(r, c);
                    if (value == 0 || (a = function.apply(r, c, value)) == value) continue;
                    this.setQuick(r, c, a);
                }
            }
        }
        return this;
    }

    public int get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                int value = this.getQuick(r, c);
                if (value >= 0) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                int value = this.getQuick(r, c);
                if (value == 0) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                int value = this.getQuick(r, c);
                if (value <= 0) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public abstract int getQuick(int var1, int var2);

    protected boolean haveSharedCells(IntMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        return false;
    }

    public IntMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract IntMatrix2D like(int var1, int var2);

    public abstract IntMatrix1D like1D(int var1);

    protected abstract IntMatrix1D like1D(int var1, int var2, int var3);

    public int[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        int maxValue = IntMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < IntMatrix2D.this.columns; ++c) {
                                int elem = IntMatrix2D.this.getQuick(r, c);
                                if (maxValue >= elem) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new int[]{maxValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (int[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    rowLocation = results[j][1];
                    columnLocation = results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    int elem = this.getQuick(r, c);
                    if (maxValue >= elem) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new int[]{maxValue, rowLocation, columnLocation};
    }

    public int[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        int minValue = IntMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < IntMatrix2D.this.columns; ++c) {
                                int elem = IntMatrix2D.this.getQuick(r, c);
                                if (minValue <= elem) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new int[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (int[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    rowLocation = results[j][1];
                    columnLocation = results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    int elem = this.getQuick(r, c);
                    if (minValue <= elem) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new int[]{minValue, rowLocation, columnLocation};
    }

    public void set(int row, int column, int value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3);

    public int[][] toArray() {
        final int[][] values = new int[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int[] currentRow = values[r];
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                currentRow[c] = IntMatrix2D.this.getQuick(r, c);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                int[] currentRow = values[r];
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.getQuick(r, c);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    public abstract IntMatrix1D vectorize();

    protected IntMatrix2D view() {
        return (IntMatrix2D)this.clone();
    }

    public IntMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public IntMatrix2D viewColumnFlip() {
        return (IntMatrix2D)this.view().vColumnFlip();
    }

    public IntMatrix2D viewDice() {
        return (IntMatrix2D)this.view().vDice();
    }

    public IntMatrix2D viewPart(int row, int column, int height, int width) {
        return (IntMatrix2D)this.view().vPart(row, column, height, width);
    }

    public IntMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public IntMatrix2D viewRowFlip() {
        return (IntMatrix2D)this.view().vRowFlip();
    }

    public IntMatrix2D viewSelection(IntMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public IntMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            for (i2 = 0; i2 < this.rows; ++i2) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            for (i2 = 0; i2 < this.columns; ++i2) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public IntMatrix2D viewSelection(Set<int[]> indexes) {
        int i;
        int n = indexes.size();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        int idx = 0;
        for (int[] is : indexes) {
            rowIndexes[idx] = is[0];
            columnIndexes[idx] = is[1];
            ++idx;
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    protected abstract IntMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public IntMatrix2D viewSorted(int column) {
        return IntSorting.mergeSort.sort(this, column);
    }

    public IntMatrix2D viewStrides(int rowStride, int columnStride) {
        return (IntMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public IntMatrix1D zMult(IntMatrix1D y, IntMatrix1D z) {
        return this.zMult(y, z, 1, z == null ? 1 : 0, false);
    }

    public IntMatrix1D zMult(final IntMatrix1D y, IntMatrix1D z, final int alpha, final int beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        final IntMatrix1D z_loc = z == null ? new DenseIntMatrix1D(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > z_loc.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z_loc.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int s = 0;
                            for (int c = 0; c < IntMatrix2D.this.columns; ++c) {
                                s += IntMatrix2D.this.getQuick(r, c) * y.getQuick(c);
                            }
                            z_loc.setQuick(r, alpha * s + beta * z_loc.getQuick(r));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                int s = 0;
                for (int c = 0; c < this.columns; ++c) {
                    s += this.getQuick(r, c) * y.getQuick(c);
                }
                z_loc.setQuick(r, alpha * s + beta * z_loc.getQuick(r));
            }
        }
        return z_loc;
    }

    public IntMatrix2D zMult(IntMatrix2D B, IntMatrix2D C) {
        return this.zMult(B, C, 1, C == null ? 1 : 0, false, false);
    }

    public IntMatrix2D zMult(final IntMatrix2D B, IntMatrix2D C, final int alpha, final int beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final IntMatrix2D C_loc = C == null ? new DenseIntMatrix2D(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C_loc.rows != m || C_loc.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C_loc.toStringShort());
        }
        if (this == C_loc || B == C_loc) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int a = firstIdx; a < lastIdx; ++a) {
                            for (int b = 0; b < m; ++b) {
                                int s = 0;
                                for (int c = 0; c < n; ++c) {
                                    s += IntMatrix2D.this.getQuick(b, c) * B.getQuick(c, a);
                                }
                                C_loc.setQuick(b, a, alpha * s + beta * C_loc.getQuick(b, a));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int a = 0; a < p; ++a) {
                for (int b = 0; b < m; ++b) {
                    int s = 0;
                    for (int c = 0; c < n; ++c) {
                        s += this.getQuick(b, c) * B.getQuick(c, a);
                    }
                    C_loc.setQuick(b, a, alpha * s + beta * C_loc.getQuick(b, a));
                }
            }
        }
        return C_loc;
    }

    public int zSum() {
        if (this.size() == 0L) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

