/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tdouble;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.LongDoubleProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public abstract class AbstractLongDoubleMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractLongDoubleMap() {
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                AbstractLongDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractLongDoubleMap other) {
        this.clear();
        other.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                AbstractLongDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public boolean containsKey(final long key) {
        return !this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractLongDoubleMap copy() {
        return (AbstractLongDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongDoubleMap)) {
            return false;
        }
        final AbstractLongDoubleMap other = (AbstractLongDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                return AbstractLongDoubleMap.this.containsKey(key) && AbstractLongDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongDoubleProcedure procedure) {
        return this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                return procedure.apply(key, AbstractLongDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(long var1);

    public long keyOf(final double value) {
        final long[] foundKey = new long[1];
        boolean notFound = this.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long iterKey, double iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Long.MIN_VALUE;
        }
        return foundKey[0];
    }

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final LongDoubleProcedure condition, final LongArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        int size = keyList.size();
        valueList.setSize(size);
        final double[] valueListElements = valueList.elements();
        final long[] keyListElements = keyList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            valueListElements[i] = AbstractLongDoubleMap.this.get(keyListElements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = keyList.size();
            while (--i >= 0) {
                valueListElements[i] = this.get(keyListElements[i]);
            }
        }
    }

    public void pairsSortedByValue(LongArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                long t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(long var1, double var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        String tmp = theKeys.toString() + "\n";
        theKeys.sort();
        StringBuffer buf = new StringBuffer(tmp);
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        LongArrayList theKeys = new LongArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                list.add(AbstractLongDoubleMap.this.get(key));
                return true;
            }
        });
    }
}

