/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

public class Timer {
    private long baseTime;
    private long elapsedTime;

    public Timer() {
        this.reset();
    }

    public Timer display() {
        System.out.println(this);
        return this;
    }

    public double elapsedTime() {
        return this.seconds();
    }

    public double millis() {
        long elapsed = this.elapsedTime;
        if (this.baseTime != 0L) {
            elapsed += System.nanoTime() - this.baseTime;
        }
        return (double)elapsed / 1000000.0;
    }

    public long nanos() {
        long elapsed = this.elapsedTime;
        if (this.baseTime != 0L) {
            elapsed += System.nanoTime() - this.baseTime;
        }
        return elapsed;
    }

    public Timer minus(Timer other) {
        Timer copy = new Timer();
        copy.elapsedTime = this.nanos() - other.nanos();
        return copy;
    }

    public double minutes() {
        return this.seconds() / 60.0;
    }

    public Timer plus(Timer other) {
        Timer copy = new Timer();
        copy.elapsedTime = this.nanos() + other.nanos();
        return copy;
    }

    public Timer reset() {
        this.elapsedTime = 0L;
        this.baseTime = 0L;
        return this;
    }

    public double seconds() {
        return (double)this.nanos() / 1.0E9;
    }

    public Timer start() {
        this.baseTime = System.nanoTime();
        return this;
    }

    public Timer stop() {
        if (this.baseTime != 0L) {
            this.elapsedTime += System.nanoTime() - this.baseTime;
        }
        this.baseTime = 0L;
        return this;
    }

    public static void test(int size) {
        int i;
        Timer t = new Timer().start();
        int j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop();
        t.display();
        System.out.println("I finished the test using " + t);
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.start();
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop().display();
        t.reset();
        t.start();
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop().display();
    }

    public String toString() {
        return "Time=" + String.format("%.4f", this.elapsedTime()) + " secs";
    }
}

