/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Locale;
import java.util.Vector;
import units.Alias;
import units.Env;
import units.EvalError;
import units.Ignore;
import units.Util;
import units.Value;

class UnitList {
    int n;
    String[] unit;
    Value[] value;
    int round = 1;

    UnitList(String unitlist) {
        String list = unitlist.trim();
        int lg = list.length();
        if (list.endsWith(";;")) {
            this.round = 0;
            list = list.substring(0, lg - 2);
            lg -= 2;
        } else if (list.endsWith(";")) {
            this.round = 2;
            list = list.substring(0, lg - 1);
            --lg;
        }
        if (Env.round) {
            this.round = 0;
        }
        Vector<String> items = new Vector<String>();
        int i = 0;
        while (i <= lg) {
            int j = list.indexOf(59, i);
            if (j < 0) {
                j = lg;
            }
            items.add(list.substring(i, j).trim());
            i = j + 1;
        }
        this.n = items.size();
        this.unit = new String[this.n];
        items.toArray(this.unit);
        this.value = new Value[this.n];
        for (i = 0; i < this.n; ++i) {
            if (this.unit[i].isEmpty()) {
                throw new EvalError("Element " + (i + 1) + " is empty.");
            }
            this.value[i] = null;
            try {
                this.value[i] = Value.parse(this.unit[i]);
            }
            catch (EvalError e) {
                throw new EvalError("Element " + (i + 1) + " is not valid. " + e.getMessage());
            }
            this.value[i].completereduce();
        }
        for (i = 1; i < this.n; ++i) {
            if (this.value[i - 1].isCompatibleWith(this.value[i], Ignore.DIMLESS)) continue;
            throw new EvalError("Conformability error:\n\t" + this.unit[i - 1] + " = " + this.value[i - 1].asString() + "\n\t" + this.unit[i] + " = " + this.value[i].asString());
        }
    }

    static String isUnitList(String s) {
        Alias alias = Alias.table.get(s);
        if (alias != null) {
            return alias.unitList;
        }
        if (s.indexOf(59) > 0) {
            return s;
        }
        return null;
    }

    boolean convert(String fromExpr, Value fromValue) {
        Double rounded;
        if (!fromValue.isCompatibleWith(this.value[0], Ignore.DIMLESS)) {
            Env.out.println("Conformability error");
            Env.out.println("\t" + fromExpr + " = " + fromValue.asString());
            Env.out.println("\t" + this.unit[0] + " = " + this.value[0].asString());
            return false;
        }
        double[] result = new double[this.n];
        double rem = fromValue.factor;
        for (int i = 0; i < this.n - 1; ++i) {
            result[i] = Math.floor(rem / this.value[i].factor);
            rem -= result[i] * this.value[i].factor;
        }
        result[this.n - 1] = rem / this.value[this.n - 1].factor;
        double roundAmount = 0.0;
        if (this.round == 0) {
            rounded = Math.floor(result[this.n - 1] + 0.5);
            roundAmount = rounded - result[this.n - 1];
        } else {
            rounded = Double.valueOf(String.format(Locale.US, "%.8g", result[this.n - 1]));
        }
        result[this.n - 1] = rounded;
        if (this.round == 2) {
            result[this.n - 1] = Math.floor(rounded);
            rounded = rounded - result[this.n - 1];
        }
        for (int i = this.n - 1; i > 0; --i) {
            double nextUnit = this.value[i - 1].factor / this.value[i].factor;
            if (result[i] != (nextUnit = Double.valueOf(String.format(Locale.US, "%.8g", nextUnit)).doubleValue())) continue;
            result[i] = 0.0;
            int n = i - 1;
            result[n] = result[n] + 1.0;
        }
        StringBuilder sb = new StringBuilder();
        if (Env.verbose > 0) {
            sb.append("\t");
            if (Env.verbose == 2) {
                sb.append(fromExpr + " = ");
            }
            String sep = "";
            for (int i = 0; i < this.n; ++i) {
                if (result[i] == 0.0) continue;
                sb.append(sep + this.showUnit(result[i], this.unit[i]));
                sep = " + ";
            }
            if (this.round == 2 && rounded != 0.0) {
                sb.append(sep + this.showUnit(rounded, this.unit[this.n - 1]));
            }
            if (sb.length() == 0) {
                sb.append("0 " + this.unit[0]);
            }
            if (roundAmount > 0.0) {
                sb.append(" (rounded up to nearest " + this.unit[this.n - 1] + ")");
            }
            if (roundAmount < 0.0) {
                sb.append(" (rounded down to nearest " + this.unit[this.n - 1] + ")");
            }
        } else {
            String sep = "";
            for (int i = 0; i < this.n; ++i) {
                sb.append(sep + Util.shownumber(result[i]));
                sep = ";";
            }
            if (this.round == 2) {
                sb.append(sep + Util.shownumber(rounded));
            }
            if (roundAmount > 0.0) {
                sb.append(";-");
            }
            if (roundAmount < 0.0) {
                sb.append(";+");
            }
        }
        Env.out.println(sb.toString());
        return true;
    }

    private String showUnit(double value, String unit) {
        int p = Util.indexOf("+-", unit, 0);
        if (p != unit.length()) {
            if (value == 1.0) {
                return "(" + unit + ")";
            }
            return Util.shownumber(value) + " (" + unit + ")";
        }
        if (value == (double)((int)value) && value < 10000.0 && unit.length() > 2 && unit.substring(0, 2).equals("1|")) {
            int i;
            for (i = 2; i < unit.length() && "0123456789".indexOf(unit.charAt(i)) >= 0; ++i) {
            }
            if (i > 1 && i < 6) {
                return Util.shownumber(value) + unit.substring(1);
            }
        }
        if ("0123456789.,".indexOf(unit.charAt(0)) >= 0) {
            if (value == 1.0) {
                return unit;
            }
            return Util.shownumber(value) + " * " + unit;
        }
        return Util.shownumber(value) + " " + unit;
    }
}

