/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.DefinedFunction;
import units.Entity;
import units.Env;
import units.EvalError;
import units.Function;
import units.Ignore;
import units.Location;
import units.Util;
import units.Value;

class TabularFunction
extends DefinedFunction {
    private final double[] x;
    private final double[] y;
    private final String resUnit;

    TabularFunction(String name, Location loc, String resUnit, double[] x, double[] y) {
        super(name, loc);
        this.resUnit = resUnit;
        this.x = x;
        this.y = y;
    }

    static void define(String name, String resUnit, double[] x, double[] y, Location loc) {
        String diag = Entity.checkName(name);
        if (diag != null) {
            Env.out.println(loc.where() + ". Function '" + name + "' is ignored. Its name " + diag + ".");
            return;
        }
        Function old = table.put(name, new TabularFunction(name, loc, resUnit, x, y));
        if (old != null) {
            Env.out.println("Function '" + name + "' defined in " + old.location.where() + ", is redefined in " + loc.where() + ".");
        }
    }

    @Override
    void applyTo(Value v) {
        Value dim = null;
        try {
            dim = Value.parse(this.resUnit);
        }
        catch (EvalError e) {
            throw new EvalError("Invalid result unit, " + this.resUnit + ", of function " + this.name + ". " + e.getMessage());
        }
        if (!v.isNumber()) {
            throw new EvalError("Argument " + v.asString() + " of '" + this.name + "' is not a number.");
        }
        double result = this.interpolate(v.factor, this.x, this.y, v, "");
        dim.factor *= result;
        v.copyFrom(dim);
    }

    @Override
    void applyInverseTo(Value v) {
        Value dim = null;
        try {
            dim = Value.parse(this.resUnit);
        }
        catch (EvalError e) {
            throw new EvalError("Invalid result unit, '" + this.resUnit + "', of '" + this.name + "'. " + e.getMessage());
        }
        Value n = new Value(v);
        n.div(dim);
        if (!n.isNumber()) {
            throw new EvalError("Argument " + v.asString() + " of '~" + this.name + "' is not conformable to '" + this.resUnit + "'.");
        }
        double result = this.interpolate(n.factor, this.y, this.x, v, "~");
        v.copyFrom(new Value());
        v.factor = result;
    }

    @Override
    String showdef() {
        String pref = "0123456789.".indexOf(this.resUnit.charAt(0)) >= 0 ? " * " : " ";
        StringBuilder sb = new StringBuilder("Interpolated table with points:");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append((Env.verbose > 0 ? "\n\t\t    " : "\n ") + this.name + "(" + this.x[i] + ") = " + this.y[i] + pref + this.resUnit);
        }
        return sb.toString();
    }

    @Override
    void check() {
        if (Env.verbose == 2) {
            Env.out.println(this.location.where() + ". Doing function " + this.name);
        }
        this.checkHiding();
        try {
            Value.parse(this.resUnit);
        }
        catch (EvalError e) {
            Env.out.println(this.location.where() + ". Invalid result unit, '" + this.resUnit + "', of '" + this.name + "'. " + e.getMessage());
        }
        if (this.x.length <= 1) {
            Env.out.println(this.location.where() + ". Table '" + this.name + "' has only one data point.");
            return;
        }
        int direction = TabularFunction.signum(this.y[1] - this.y[0]);
        for (int i = 2; i < this.x.length; ++i) {
            if (direction != 0 && TabularFunction.signum(this.y[i] - this.y[i - 1]) == direction) continue;
            Env.out.println(this.location.where() + ". Table '" + this.name + "' lacks unique inverse around entry " + Util.shownumber(this.x[i - 1]) + ".");
            return;
        }
    }

    @Override
    boolean conformsTo(Value v) {
        try {
            Value thisvalue = Value.parse(this.resUnit);
            thisvalue.completereduce();
            return thisvalue.isCompatibleWith(v, Ignore.DIMLESS);
        }
        catch (EvalError e) {
            return false;
        }
    }

    @Override
    String desc() {
        return "<function>";
    }

    private double interpolate(double inval, double[] in, double[] out, Value v, String inv) {
        for (int i = 0; i < in.length - 1; ++i) {
            if (!(in[i] <= inval && inval <= in[i + 1]) && (!(in[i] >= inval) || !(inval >= in[i + 1]))) continue;
            return out[i] + (inval - in[i]) * (out[i + 1] - out[i]) / (in[i + 1] - in[i]);
        }
        throw new EvalError("Argument " + v.asString() + " is outside the domain of '" + inv + this.name + "'.");
    }

    private static int signum(double d) {
        return d == 0.0 ? 0 : (d > 0.0 ? 1 : -1);
    }
}

