/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Hashtable;
import units.Env;
import units.EvalError;
import units.Function;
import units.Location;
import units.Prefix;
import units.Unit;
import units.Value;

abstract class DefinedFunction
extends Function {
    static Hashtable<String, DefinedFunction> table = null;

    DefinedFunction(String name, Location loc) {
        super(name, loc);
    }

    void checkHiding() {
        Prefix pref;
        Unit unit = Unit.table.get(this.name);
        if (unit != null) {
            Env.out.println(this.location.where() + ". Function '" + this.name + "' hides the unit defined in " + unit.location.where() + ".");
        }
        if ((pref = Prefix.table.get(this.name)) != null) {
            Env.out.println(this.location.where() + ". Function '" + this.name + "' hides the prefix defined in " + pref.location.where() + ".");
        }
    }

    static String showdef(String name) {
        Function func = table.get(name);
        if (func != null) {
            return func.showdef();
        }
        return null;
    }

    boolean convert(String fromExpr, Value fromValue) {
        try {
            this.applyInverseTo(fromValue);
            fromValue.completereduce();
        }
        catch (EvalError e) {
            Env.out.println(e.getMessage());
            return false;
        }
        if (Env.verbose == 2) {
            Env.out.print("\t" + fromExpr + " = " + this.name + "(");
        } else if (Env.verbose == 1) {
            Env.out.print("\t");
        }
        Env.out.print(fromValue.asString());
        if (Env.verbose == 2) {
            Env.out.print(")");
        }
        Env.out.print("\n");
        return true;
    }
}

