/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.variable;

import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.jdmp.core.sample.Sample;
import org.jdmp.core.variable.HasVariableMap;
import org.jdmp.core.variable.Variable;

public class VariableListTableModel
extends AbstractTableModel
implements ListDataListener {
    private static final long serialVersionUID = -1032855724069297926L;
    public static final int IDCOLUMN = 0;
    public static final int LABELCOLUMN = 1;
    public static final int SIZECOLUMN = 2;
    public static final int MATRIXCOLUMN = 3;
    public static final int PLOTCOLUMN = 4;
    public static final int MATRIXCOUNTCOLUMN = 5;
    private HasVariableMap iVariables = null;
    private Sample sample = null;

    public VariableListTableModel(HasVariableMap iVariables) {
        this.iVariables = iVariables;
        iVariables.getVariableMap().addListDataListener(this);
    }

    public VariableListTableModel(Sample sample) {
        this.sample = sample;
    }

    @Override
    public int getRowCount() {
        return this.sample == null ? this.iVariables.getVariableMap().getSize() : this.sample.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Id";
            }
            case 1: {
                return "Label";
            }
            case 2: {
                return "Size";
            }
            case 3: {
                return "Matrix";
            }
            case 4: {
                return "Plot";
            }
            case 5: {
                return "MatrixCount";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Variable.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.sample == null ? this.iVariables.getVariableMap().getElementAt(rowIndex) : this.sample.getAsObject(rowIndex, 1L);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
    }
}

