/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.variable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.jdmp.core.variable.Variable;
import org.jdmp.gui.variable.VariableListImageObserver;
import org.ujmp.core.Matrix;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;
import org.ujmp.gui.util.UIDefaults;

public class VariableListTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 6410777671579311509L;
    private final BufferedImage bufferedImage = null;
    private final VariableListImageObserver variableListImageObserver = new VariableListImageObserver();
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private List variableList = null;
    private final MatrixHeatmapRenderer matrixRenderer = new MatrixHeatmapRenderer();
    private static int PADDINGX = UIManager.getInt("Table.paddingX");
    private static int PADDINGY = UIManager.getInt("Table.paddingY");
    private int width = 0;
    private int height = 0;
    private boolean isSelected;
    private boolean hasFocus;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
        this.variableList = value instanceof List ? (List)value : null;
        this.width = table.getColumnModel().getColumn(column).getWidth() - 2 * PADDINGX - 1;
        this.height = table.getRowHeight(row) - 2 * PADDINGY - 1;
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        if (this.variableList != null && this.variableList.size() > 0) {
            for (Object o : this.variableList) {
                if (!(o instanceof Variable)) continue;
                Variable v = (Variable)o;
                this.add(this.matrixRenderer.getTableCellRendererComponent(table, v.getLast(), isSelected, hasFocus, row, column));
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.variableList == null) {
            Graphics2D g2d = (Graphics2D)g;
            if (g2d != null) {
                g2d.addRenderingHints(UIDefaults.AALIAS);
                g2d.setColor(Color.RED);
                g2d.drawLine(PADDINGX, PADDINGY, this.width - PADDINGX, this.height - PADDINGY);
                g2d.drawLine(this.width - PADDINGX, PADDINGY, PADDINGX, this.height - PADDINGY);
                g2d.dispose();
            }
        } else {
            this.paintVariableList(g, this.variableList);
        }
    }

    public void paintVariableList(Graphics g, List variableList) {
        if (variableList == null) {
            return;
        }
        int count = variableList.size();
        if (count == 0) {
            return;
        }
        int componentWidth = this.width / count;
        for (Object o : variableList) {
            if (o == null || !(o instanceof Variable)) continue;
            Variable v = (Variable)o;
            MatrixHeatmapRenderer.paintMatrix(g, (MatrixGUIObject)((Matrix)v.getLast()).getGUIObject(), componentWidth, this.height + PADDINGY + PADDINGY);
            g.translate(componentWidth, 0);
        }
    }
}

