/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.sample;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdmp.core.sample.Sample;
import org.jdmp.gui.sample.SampleListTableModel;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;

public class SampleTableCellRenderer
implements TableCellRenderer {
    private static final Border borderSelected = BorderFactory.createLineBorder(Color.blue, 1);
    private static final Border borderNotSelected = BorderFactory.createLineBorder(Color.white, 1);
    private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private final MatrixHeatmapRenderer matrixRenderer = new MatrixHeatmapRenderer();
    private Map<Integer, String> columnMap = null;
    private Sample sample = null;
    private Object o = null;
    private JLabel c = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.columnMap = ((SampleListTableModel)table.getModel()).getColumnMap();
        this.c = null;
        this.sample = value instanceof Sample ? (Sample)value : null;
        if (this.sample != null) {
            String key = this.columnMap.get(column);
            Object mv = this.sample.get(key);
            if (mv == null) {
                this.o = "";
            } else {
                if (mv instanceof Matrix) {
                    return this.matrixRenderer.getTableCellRendererComponent(table, mv, isSelected, hasFocus, row, column);
                }
                this.o = String.valueOf(mv);
            }
            this.c = (JLabel)this.renderer.getTableCellRendererComponent(table, this.o, isSelected, hasFocus, row, column);
            this.c.setIcon(null);
            this.c.setHorizontalAlignment(0);
            if (mv == null) {
                this.c.setBackground(Color.BLACK);
            } else if (mv instanceof Matrix) {
                this.c.setBackground(Color.WHITE);
            } else {
                this.c.setBackground(ColorUtil.fromObject(mv));
            }
        }
        if (isSelected) {
            this.c.setBorder(borderSelected);
        } else {
            this.c.setBorder(borderNotSelected);
        }
        return this.c;
    }
}

