/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.util;

import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FastListSelectionModel
implements ListSelectionModel {
    private int selectionMode = 1;
    private int minIndex = -1;
    private int maxIndex = -1;
    private boolean valueIsAdjusting = false;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (index1 > index0) {
            this.minIndex = Math.min(this.minIndex, index0);
            this.maxIndex = Math.max(this.maxIndex, index1);
        } else {
            this.minIndex = Math.min(this.minIndex, index1);
            this.maxIndex = Math.max(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    @Override
    public void clearSelection() {
        this.minIndex = -1;
        this.maxIndex = -1;
        this.fireValueChanged();
    }

    private void fireValueChanged() {
        this.fireValueChanged(0, Integer.MAX_VALUE);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.minIndex;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.minIndex;
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.maxIndex;
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this.minIndex = Math.min(this.minIndex, index);
        this.maxIndex = Math.max(this.maxIndex, index + length);
        this.fireValueChanged();
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return index >= this.minIndex && index <= this.maxIndex;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.minIndex == -1 || this.maxIndex == -1;
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.minIndex = Math.min(this.minIndex, index);
        this.fireValueChanged();
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.maxIndex = Math.max(this.maxIndex, index);
        this.fireValueChanged();
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (index1 > index0) {
            this.minIndex = index0;
            this.maxIndex = index1;
        } else {
            this.minIndex = index1;
            this.maxIndex = index0;
        }
        this.fireValueChanged();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }
}

