/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.matrix.system;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class LogMatrix
extends AbstractDenseObjectMatrix2D {
    private static final long serialVersionUID = 4054005288748742516L;
    private static LogMatrix matrix = null;

    public static final LogMatrix getInstance() {
        if (matrix == null) {
            matrix = new LogMatrix();
            matrix.setLabel("Log");
        }
        return matrix;
    }

    private LogMatrix() {
        super(0L, 0L);
        HandlerWrapper.getInstance().setMatrix(this);
    }

    @Override
    public long[] getSize() {
        return new long[]{HandlerWrapper.getInstance().getList().size(), 7L};
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    @Override
    public Object getObject(int row, int column) {
        LogRecord record = HandlerWrapper.getInstance().getList().get(row);
        switch (column) {
            case 0: {
                return record.getMillis();
            }
            case 1: {
                return record.getLevel();
            }
            case 2: {
                return record.getMessage();
            }
            case 3: {
                return record.getSourceClassName();
            }
            case 4: {
                return record.getSourceMethodName();
            }
            case 5: {
                return record.getParameters()[0];
            }
            case 6: {
                return record.getThrown();
            }
        }
        return null;
    }

    @Override
    public void setObject(Object o, long row, long column) {
    }

    @Override
    public void setObject(Object o, int row, int column) {
    }

    public static class HandlerWrapper
    extends Handler {
        private static HandlerWrapper handler = null;
        private final List<LogRecord> list = new ArrayList<LogRecord>();
        private Matrix matrix = null;

        private HandlerWrapper() {
        }

        public static HandlerWrapper getInstance() {
            if (handler == null) {
                handler = new HandlerWrapper();
            }
            return handler;
        }

        protected void setMatrix(Matrix matrix) {
            this.matrix = matrix;
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            record.setParameters(new Object[]{Runtime.getRuntime().freeMemory(), Runtime.getRuntime()});
            this.list.add(record);
            if (this.matrix != null) {
                this.matrix.fireValueChanged();
            }
        }

        public List<LogRecord> getList() {
            return this.list;
        }
    }
}

