/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.dataset;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.dataset.AbstractListDataSet;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.MatrixSample;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class MatrixDataSet
extends AbstractListDataSet {
    private static final long serialVersionUID = -2697648740183157641L;
    public static final int MAXSAMPLES = 10000;
    private final Map<Integer, Sample> sampleBuffer = new HashMap<Integer, Sample>();

    public MatrixDataSet(Matrix input) {
        this.setMetaData("Input", input);
    }

    @Override
    public synchronized Sample get(int index) {
        Sample sample = this.sampleBuffer.get(index);
        if (sample == null) {
            sample = new MatrixSample(this, index);
            this.sampleBuffer.put(index, sample);
            while (this.sampleBuffer.size() > 10000) {
                this.sampleBuffer.remove(this.sampleBuffer.keySet().iterator().next());
            }
        }
        return sample;
    }

    @Override
    public boolean addToList(Sample t) {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public void addToList(int index, Sample element) {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public Sample removeFromList(int index) {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public Sample setToList(int index, Sample element) {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public void clearList() {
        throw new RuntimeException("number of samples cannot be changed");
    }

    @Override
    public int size() {
        return MathUtil.longToInt(this.getMetaDataMatrix("Input").getRowCount());
    }

    @Override
    public ListDataSet clone() {
        throw new RuntimeException("not implemented");
    }
}

