/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.dataset;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.BitSet;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.jdmp.core.algorithm.basic.CreateIris;
import org.jdmp.core.dataset.AbstractDataSetFactory;
import org.jdmp.core.dataset.AbstractListDataSet;
import org.jdmp.core.dataset.DataSet;
import org.jdmp.core.dataset.DefaultListDataSet;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.dataset.MatrixDataSet;
import org.jdmp.core.sample.Sample;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.DBType;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.objectmatrix.ObjectMatrix;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.io.HttpUtil;

public class DefaultDataSetFactory
extends AbstractDataSetFactory {
    @Override
    public ListDataSet emptyDataSet() {
        return new DefaultListDataSet();
    }

    @Override
    public ListDataSet importFromFile(FileFormat format, File file, Object ... parameters) throws IOException {
        switch (format) {
            default: 
        }
        Matrix m = Matrix.Factory.importFrom().file(file).asDenseCSV();
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet linkToFile(FileFormat format, File file, Object ... parameters) throws IOException {
        switch (format) {
            default: 
        }
        Matrix m = Matrix.Factory.linkTo().file(file).asDenseCSV();
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet linkToInput(Matrix input) {
        MatrixDataSet ds = new MatrixDataSet(input);
        return ds;
    }

    @Override
    public ListDataSet linkToInputAndLabels(Matrix input, Matrix labels) {
        MatrixDataSet ds = new MatrixDataSet(input);
        ds.setMatrix("Labels", labels);
        return ds;
    }

    @Override
    public ListDataSet linkToInputAndTarget(Matrix input, Matrix target) {
        MatrixDataSet ds = new MatrixDataSet(input);
        ds.setMatrix("Target", target);
        return ds;
    }

    @Override
    public ListDataSet linkToInputTargetAndLabel(Matrix input, Matrix target, Matrix labels) {
        MatrixDataSet ds = new MatrixDataSet(input);
        ds.setMatrix("Labels", labels);
        ds.setMatrix("Target", target);
        return ds;
    }

    @Override
    public ListDataSet HenonMap(int sampleCount, int inputLength, int predictionLength) {
        AbstractListDataSet henon = ListDataSet.Factory.labeledDataSet("Henon Map");
        Random random = new Random();
        for (int si = 0; si < sampleCount; ++si) {
            double q1 = random.nextDouble() * 1.26 * 2.0 - 1.26;
            q1 = q1 >= 1.26 ? q1 - 1.26 : q1;
            q1 = q1 < -1.26 ? q1 + 1.26 : q1;
            double q2 = random.nextDouble() * 1.26 * 2.0 - 1.26;
            q2 = q2 >= 1.26 ? q2 - 1.26 : q2;
            q2 = q2 < -1.26 ? q2 + 1.26 : q2;
            double q = 0.0;
            DenseMatrix input = Matrix.Factory.zeros(1L, (long)inputLength);
            for (int i = 0; i < inputLength; ++i) {
                q = DefaultDataSetFactory.henon(q1, q2);
                input.setAsDouble(q / 2.0, 0L, i);
                q2 = q1;
                q1 = q;
            }
            DenseMatrix target = Matrix.Factory.zeros(1L, (long)predictionLength);
            for (int i = 0; i < predictionLength; ++i) {
                q = DefaultDataSetFactory.henon(q1, q2);
                target.setAsDouble(q / 2.0, 0L, i);
                q2 = q1;
                q1 = q;
            }
            Sample s = Sample.Factory.labeledSample("Sample " + si);
            s.put("Input", input);
            s.put("Target", target);
            henon.add(s);
        }
        return henon;
    }

    private static double henon(double q1, double q2) {
        double a = 1.4;
        double b = 0.3;
        double y = 1.0 - a * q1 * q1 + b * q2;
        double q = y;
        q = q >= 1.26 ? q - 1.26 : q;
        q = q < -1.26 ? q + 1.26 : q;
        return q;
    }

    @Override
    public ListDataSet LogisticMap(int sampleCount, int inputLength, int predictionLength) {
        AbstractListDataSet logistic = ListDataSet.Factory.labeledDataSet("Logistic Map");
        double r = 3.82;
        Random random = new Random();
        for (int si = 0; si < sampleCount; ++si) {
            double x = random.nextDouble();
            DenseMatrix input = Matrix.Factory.zeros(1L, (long)inputLength);
            for (int i = 0; i < inputLength; ++i) {
                x = r * x * (1.0 - x);
                input.setAsDouble(x, 0L, i);
            }
            DenseMatrix target = Matrix.Factory.zeros(1L, (long)predictionLength);
            for (int i = 0; i < predictionLength; ++i) {
                x = r * x * (1.0 - x);
                target.setAsDouble(x, 0L, i);
            }
            Sample s = Sample.Factory.labeledSample("Sample " + si);
            s.put("Input", input);
            s.put("Target", target);
            logistic.add(s);
        }
        return logistic;
    }

    @Override
    public AbstractListDataSet ANIMALS() {
        AbstractListDataSet animals = ListDataSet.Factory.labeledDataSet("Animals");
        Sample pigeon = Sample.Factory.labeledSample("Pigeon");
        pigeon.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0).transpose());
        animals.add(pigeon);
        Sample chicken = Sample.Factory.labeledSample("Chicken");
        chicken.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0).transpose());
        animals.add(chicken);
        Sample duck = Sample.Factory.labeledSample("Duck");
        duck.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0).transpose());
        animals.add(duck);
        Sample goose = Sample.Factory.labeledSample("Goose");
        goose.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0).transpose());
        animals.add(goose);
        Sample owl = Sample.Factory.labeledSample("Owl");
        owl.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0).transpose());
        animals.add(owl);
        Sample falcon = Sample.Factory.labeledSample("Falcon");
        falcon.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0).transpose());
        animals.add(falcon);
        Sample eagle = Sample.Factory.labeledSample("Eagle");
        eagle.put("Input", Matrix.Factory.linkToArray(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0).transpose());
        animals.add(eagle);
        Sample fox = Sample.Factory.labeledSample("Fox");
        fox.put("Input", Matrix.Factory.linkToArray(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0).transpose());
        animals.add(fox);
        Sample dog = Sample.Factory.labeledSample("Dog");
        dog.put("Input", Matrix.Factory.linkToArray(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0).transpose());
        animals.add(dog);
        Sample wolf = Sample.Factory.labeledSample("Wolf");
        wolf.put("Input", Matrix.Factory.linkToArray(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0).transpose());
        animals.add(wolf);
        Sample cat = Sample.Factory.labeledSample("Cat");
        cat.put("Input", Matrix.Factory.linkToArray(1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0).transpose());
        animals.add(cat);
        Sample tiger = Sample.Factory.labeledSample("Tiger");
        tiger.put("Input", Matrix.Factory.linkToArray(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0).transpose());
        animals.add(tiger);
        Sample lion = Sample.Factory.labeledSample("Lion");
        lion.put("Input", Matrix.Factory.linkToArray(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0).transpose());
        animals.add(lion);
        Sample horse = Sample.Factory.labeledSample("Horse");
        horse.put("Input", Matrix.Factory.linkToArray(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0).transpose());
        animals.add(horse);
        Sample zebra = Sample.Factory.labeledSample("Zebra");
        zebra.put("Input", Matrix.Factory.linkToArray(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0).transpose());
        animals.add(zebra);
        Sample cow = Sample.Factory.labeledSample("Cow");
        cow.put("Input", Matrix.Factory.linkToArray(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0).transpose());
        animals.add(cow);
        return animals;
    }

    @Override
    public final AbstractListDataSet labeledDataSet(String label) {
        DefaultListDataSet ds = new DefaultListDataSet();
        ds.setLabel(label);
        return ds;
    }

    @Override
    public ListDataSet CountActive(int number) {
        AbstractListDataSet ds = this.labeledDataSet("Count " + number);
        double possibilites = Math.pow(2.0, number);
        int i = 0;
        while ((double)i < possibilites) {
            BitSet bits = BitSet.valueOf(new long[]{i});
            Sample sample = Sample.Factory.labeledSample("" + i);
            DenseMatrix input = Matrix.Factory.zeros(1L, (long)number);
            DenseMatrix target = Matrix.Factory.zeros(1L, (long)(number + 1));
            int count = 0;
            for (int j = 0; j < number; ++j) {
                if (!bits.get(j)) continue;
                input.setAsDouble(1.0, 0L, j);
                ++count;
            }
            target.setAsDouble(1.0, 0L, count);
            sample.put("Input", input);
            sample.put("Target", target);
            ds.add(sample);
            ++i;
        }
        return ds;
    }

    @Override
    public ListDataSet Linear1() {
        AbstractListDataSet or = this.labeledDataSet("Linear1");
        Sample x0 = Sample.Factory.labeledSample("0.0=0.0");
        x0.put("Input", Matrix.Factory.linkToArray(0.0).transpose());
        x0.put("Target", Matrix.Factory.linkToArray(0.0).transpose());
        or.add(x0);
        Sample x1 = Sample.Factory.labeledSample("0.1=0.1");
        x1.put("Input", Matrix.Factory.linkToArray(0.1).transpose());
        x1.put("Target", Matrix.Factory.linkToArray(0.1).transpose());
        or.add(x1);
        Sample x2 = Sample.Factory.labeledSample("0.2=0.2");
        x2.put("Input", Matrix.Factory.linkToArray(0.2).transpose());
        x2.put("Target", Matrix.Factory.linkToArray(0.2).transpose());
        or.add(x2);
        Sample x3 = Sample.Factory.labeledSample("0.3=0.3");
        x3.put("Input", Matrix.Factory.linkToArray(0.3).transpose());
        x3.put("Target", Matrix.Factory.linkToArray(0.3).transpose());
        or.add(x3);
        Sample x4 = Sample.Factory.labeledSample("0.4=0.4");
        x4.put("Input", Matrix.Factory.linkToArray(0.4).transpose());
        x4.put("Target", Matrix.Factory.linkToArray(0.4).transpose());
        or.add(x4);
        Sample x5 = Sample.Factory.labeledSample("0.5=0.5");
        x5.put("Input", Matrix.Factory.linkToArray(0.5).transpose());
        x5.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x5);
        return or;
    }

    @Override
    public ListDataSet Linear3() {
        AbstractListDataSet or = this.labeledDataSet("Linear3");
        Sample x0 = Sample.Factory.labeledSample("0.0=0.5");
        x0.put("Input", Matrix.Factory.linkToArray(0.0).transpose());
        x0.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x0);
        Sample x1 = Sample.Factory.labeledSample("0.1=0.5");
        x1.put("Input", Matrix.Factory.linkToArray(0.1).transpose());
        x1.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x1);
        Sample x2 = Sample.Factory.labeledSample("0.2=0.5");
        x2.put("Input", Matrix.Factory.linkToArray(0.2).transpose());
        x2.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x2);
        Sample x3 = Sample.Factory.labeledSample("0.3=0.5");
        x3.put("Input", Matrix.Factory.linkToArray(0.3).transpose());
        x3.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x3);
        Sample x4 = Sample.Factory.labeledSample("0.4=0.5");
        x4.put("Input", Matrix.Factory.linkToArray(0.4).transpose());
        x4.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x4);
        Sample x5 = Sample.Factory.labeledSample("0.5=0.5");
        x5.put("Input", Matrix.Factory.linkToArray(0.5).transpose());
        x5.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x5);
        return or;
    }

    @Override
    public ListDataSet Linear2() {
        AbstractListDataSet or = this.labeledDataSet("Linear2");
        Sample x0 = Sample.Factory.labeledSample("0.0=0.1");
        x0.put("Input", Matrix.Factory.linkToArray(0.0).transpose());
        x0.put("Target", Matrix.Factory.linkToArray(0.1).transpose());
        or.add(x0);
        Sample x1 = Sample.Factory.labeledSample("0.1=0.2");
        x1.put("Input", Matrix.Factory.linkToArray(0.1).transpose());
        x1.put("Target", Matrix.Factory.linkToArray(0.2).transpose());
        or.add(x1);
        Sample x2 = Sample.Factory.labeledSample("0.2=0.3");
        x2.put("Input", Matrix.Factory.linkToArray(0.2).transpose());
        x2.put("Target", Matrix.Factory.linkToArray(0.3).transpose());
        or.add(x2);
        Sample x3 = Sample.Factory.labeledSample("0.3=0.4");
        x3.put("Input", Matrix.Factory.linkToArray(0.3).transpose());
        x3.put("Target", Matrix.Factory.linkToArray(0.4).transpose());
        or.add(x3);
        Sample x4 = Sample.Factory.labeledSample("0.4=0.5");
        x4.put("Input", Matrix.Factory.linkToArray(0.4).transpose());
        x4.put("Target", Matrix.Factory.linkToArray(0.5).transpose());
        or.add(x4);
        Sample x5 = Sample.Factory.labeledSample("0.5=0.6");
        x5.put("Input", Matrix.Factory.linkToArray(0.5).transpose());
        x5.put("Target", Matrix.Factory.linkToArray(0.6).transpose());
        or.add(x5);
        return or;
    }

    @Override
    public ListDataSet OR() {
        AbstractListDataSet or = this.labeledDataSet("OR-Problem");
        Sample x000 = Sample.Factory.labeledSample("00=01");
        x000.put("Input", Matrix.Factory.linkToArray(0.0, 0.0).transpose());
        x000.put("Target", Matrix.Factory.linkToArray(0.0, 1.0).transpose());
        or.add(x000);
        Sample x011 = Sample.Factory.labeledSample("01=10");
        x011.put("Input", Matrix.Factory.linkToArray(0.0, 1.0).transpose());
        x011.put("Target", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        or.add(x011);
        Sample x101 = Sample.Factory.labeledSample("10=10");
        x101.put("Input", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        x101.put("Target", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        or.add(x101);
        Sample x110 = Sample.Factory.labeledSample("11=10");
        x110.put("Input", Matrix.Factory.linkToArray(1.0, 1.0).transpose());
        x110.put("Target", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        or.add(x110);
        return or;
    }

    @Override
    public ListDataSet XOR() {
        AbstractListDataSet xor = this.labeledDataSet("XOR-Problem");
        Sample x000 = Sample.Factory.labeledSample("00=01");
        x000.put("Input", Matrix.Factory.linkToArray(0.0, 0.0).transpose());
        x000.put("Target", Matrix.Factory.linkToArray(0.0, 1.0).transpose());
        xor.add(x000);
        Sample x011 = Sample.Factory.labeledSample("01=10");
        x011.put("Input", Matrix.Factory.linkToArray(0.0, 1.0).transpose());
        x011.put("Target", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        xor.add(x011);
        Sample x101 = Sample.Factory.labeledSample("10=10");
        x101.put("Input", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        x101.put("Target", Matrix.Factory.linkToArray(1.0, 0.0).transpose());
        xor.add(x101);
        Sample x110 = Sample.Factory.labeledSample("11=01");
        x110.put("Input", Matrix.Factory.linkToArray(1.0, 1.0).transpose());
        x110.put("Target", Matrix.Factory.linkToArray(0.0, 1.0).transpose());
        xor.add(x110);
        return xor;
    }

    @Override
    public ListDataSet ONE() {
        AbstractListDataSet one = this.labeledDataSet("DataSet with one sample 1->1");
        Sample x1 = Sample.Factory.labeledSample("1=1");
        x1.put("Input", Matrix.Factory.linkToArray(1.0).transpose());
        x1.put("Target", Matrix.Factory.linkToArray(1.0).transpose());
        one.add(x1);
        return one;
    }

    @Override
    public ListDataSet IRIS() {
        ListDataSet ds = (ListDataSet)new CreateIris(new Variable[0]).calculate().get("Target");
        return ds;
    }

    @Override
    public ListDataSet MNISTTrain() throws IOException {
        File file2;
        ListDataSet ds = DataSet.Factory.emptyDataSet();
        File file1 = new File(UJMPSettings.getInstance().getTempDir() + "/train-images-idx3-ubyte.gz");
        if (!file1.exists()) {
            String url1 = "http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz";
            HttpUtil.download(url1, file1);
        }
        if (!(file2 = new File(UJMPSettings.getInstance().getTempDir() + "/train-labels-idx1-ubyte.gz")).exists()) {
            String url2 = "http://yann.lecun.com/exdb/mnist/train-labels-idx1-ubyte.gz";
            HttpUtil.download(url2, file2);
        }
        FileInputStream fis1 = new FileInputStream(file1);
        GZIPInputStream gis1 = new GZIPInputStream(fis1);
        FileInputStream fis2 = new FileInputStream(file2);
        GZIPInputStream gis2 = new GZIPInputStream(fis2);
        gis1.skip(16L);
        gis2.skip(8L);
        for (int i = 0; i < 60000; ++i) {
            DenseMatrix input = Matrix.Factory.zeros(28L, 28L);
            for (int row = 0; row < 28; ++row) {
                for (int col = 0; col < 28; ++col) {
                    input.setAsDouble(gis1.read(), row, col);
                }
            }
            int targetClass = gis2.read();
            Sample s = Sample.Factory.classificationSample(input, targetClass, 10);
            s.put("TargetLabel", String.valueOf(targetClass));
            ds.add(s);
        }
        gis1.close();
        fis1.close();
        gis2.close();
        fis2.close();
        return ds;
    }

    @Override
    public ListDataSet MNISTTest() throws IOException {
        int i;
        File file2;
        ListDataSet ds = DataSet.Factory.emptyDataSet();
        File file1 = new File(UJMPSettings.getInstance().getTempDir() + "/t10k-images-idx3-ubyte.gz");
        if (!file1.exists()) {
            String url1 = "http://yann.lecun.com/exdb/mnist/t10k-images-idx3-ubyte.gz";
            HttpUtil.download(url1, file1);
        }
        if (!(file2 = new File(UJMPSettings.getInstance().getTempDir() + "/t10k-labels-idx1-ubyte.gz")).exists()) {
            String url2 = "http://yann.lecun.com/exdb/mnist/t10k-labels-idx1-ubyte.gz";
            HttpUtil.download(url2, file2);
        }
        FileInputStream fis1 = new FileInputStream(file1);
        GZIPInputStream gis1 = new GZIPInputStream(fis1);
        FileInputStream fis2 = new FileInputStream(file2);
        GZIPInputStream gis2 = new GZIPInputStream(fis2);
        for (i = 0; i < 16; ++i) {
            gis1.read();
        }
        for (i = 0; i < 8; ++i) {
            gis2.read();
        }
        for (i = 0; i < 10000; ++i) {
            DenseMatrix input = Matrix.Factory.zeros(28L, 28L);
            for (int row = 0; row < 28; ++row) {
                for (int col = 0; col < 28; ++col) {
                    input.setAsInt(gis1.read(), row, col);
                }
            }
            int targetClass = gis2.read();
            Sample s = Sample.Factory.classificationSample(input, targetClass, 10);
            s.put("TargetLabel", String.valueOf(targetClass));
            ds.add(s);
        }
        gis1.close();
        fis1.close();
        gis2.close();
        fis2.close();
        return ds;
    }

    @Override
    public ListDataSet importFromURL(FileFormat fileFormat, URL url, Object ... parameters) throws Exception {
        switch (fileFormat) {
            default: 
        }
        Matrix m = Matrix.Factory.importFrom().url(url).asDenseCSV();
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet importFromClipboard() throws IOException {
        Matrix m = Matrix.Factory.importFrom().clipboard().asDenseCSV();
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet importFromJDBC(DBType type, String host, int port, String database, String sqlStatement, String username, String password) {
        ObjectMatrix m = Matrix.Factory.importFromJDBC(type, host, port, database, sqlStatement, username, password);
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet importFromJDBC(String url, String sqlStatement, String username, String password) {
        ObjectMatrix m = Matrix.Factory.importFromJDBC(url, sqlStatement, username, password);
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet linkToJDBC(DBType type, String host, int port, String database, String sqlStatement, String username, String password) {
        ObjectMatrix2D m = Matrix.Factory.linkToJDBC(type, host, port, database, sqlStatement, username, password);
        return this.linkToInput(m);
    }

    @Override
    public ListDataSet linkToJDBC(String url, String sqlStatement, String username, String password) {
        ObjectMatrix2D m = Matrix.Factory.linkToJDBC(url, sqlStatement, username, password);
        return this.linkToInput(m);
    }
}

