/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.hashing;

import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.hashing.Hashing;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.util.concurrent.PFor;

public abstract class AbstractHashing
extends AbstractAlgorithm
implements Hashing {
    private static final long serialVersionUID = 870196284002196140L;
    private String inputLabel;

    public AbstractHashing(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    public AbstractHashing() {
        this("Input");
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public int getFeatureCount(ListDataSet dataSet) {
        return (int)((Sample)dataSet.iterator().next()).getAsMatrix(this.getInputLabel()).toRowVector(Calculation.Ret.NEW).getRowCount();
    }

    public void setInputLabel(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    @Override
    public void hash(final ListDataSet dataSet) {
        new PFor(0, dataSet.size() - 1){

            @Override
            public void step(int i) {
                Sample sample = (Sample)dataSet.get(i);
                AbstractHashing.this.hash(sample);
            }
        };
    }

    @Override
    public final void hash(Sample sample) {
        Matrix output = this.hash(sample.getAsMatrix(this.getInputLabel()));
        sample.put("Hash", output);
    }
}

