/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.clustering;

import java.util.Collections;
import org.jdmp.core.algorithm.clustering.AbstractClusterer;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.util.MathUtil;

public class SelfOrganizingMap
extends AbstractClusterer {
    private static final long serialVersionUID = -7826055336085139110L;
    private int rows = 10;
    private int cols = 10;
    private int tMax = 1;
    private double epsilonStart = 0.5;
    private double epsilonEnd = 0.01;
    private double deltaStart = (double)Math.max(this.rows, this.cols) / 2.0;
    private double deltaEnd = 1.0;
    private Matrix[][] weightVectors;

    public SelfOrganizingMap() {
        this(10, 10);
    }

    public SelfOrganizingMap(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.tMax = 200;
        this.epsilonStart = 0.5;
        this.epsilonEnd = 0.001;
        this.deltaStart = (double)Math.max(rows, cols) / 2.0;
        this.deltaEnd = 0.5;
        this.weightVectors = new Matrix[rows][cols];
    }

    @Override
    public void reset() throws Exception {
        this.weightVectors = new Matrix[this.rows][this.cols];
    }

    @Override
    public void train(ListDataSet dataSet) throws Exception {
        FastArrayList<Sample> samples = new FastArrayList<Sample>(dataSet);
        for (int t = 0; t < this.tMax; ++t) {
            double epsilon = this.epsilonStart * Math.pow(this.epsilonEnd / this.epsilonStart, (double)t / (double)this.tMax);
            double delta = this.deltaStart * Math.pow(this.deltaEnd / this.deltaStart, (double)t / (double)this.tMax);
            System.out.println((int)((double)t / (double)this.tMax * 100.0) + "%");
            Collections.shuffle(samples);
            for (Sample s : samples) {
                int col;
                int row;
                Matrix input = s.getAsMatrix(this.getInputLabel());
                double bestDistance = Double.MAX_VALUE;
                int bestRow = -1;
                int bestCol = -1;
                DenseMatrix distanceMatrix = Matrix.Factory.zeros((long)this.rows, (long)this.cols);
                for (row = 0; row < this.rows; ++row) {
                    for (col = 0; col < this.cols; ++col) {
                        Matrix m = this.weightVectors[row][col];
                        if (m == null) {
                            this.weightVectors[row][col] = m = Matrix.Factory.randn(input.getSize());
                        }
                        double distance = input.euklideanDistanceTo(m, true);
                        distanceMatrix.setAsDouble(distance, row, col);
                        if (!(distance < bestDistance)) continue;
                        bestDistance = distance;
                        bestRow = row;
                        bestCol = col;
                    }
                }
                for (row = 0; row < this.rows; ++row) {
                    for (col = 0; col < this.cols; ++col) {
                        double dist = Math.sqrt((row - bestRow) * (row - bestRow) + (col - bestCol) * (col - bestCol));
                        double h = MathUtil.gauss(0.0, delta, dist);
                        Matrix w = this.weightVectors[row][col];
                        this.weightVectors[row][col] = w = w.plus(input.minus(w).times(epsilon * h));
                    }
                }
                if (t != this.tMax - 1) continue;
                s.put("Projection", distanceMatrix);
            }
        }
    }

    @Override
    public Matrix predict(Matrix input, Matrix sampleWeight) throws Exception {
        return null;
    }
}

