/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.clustering;

import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.clustering.Clusterer;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;

public abstract class AbstractClusterer
extends AbstractAlgorithm
implements Clusterer {
    private static final long serialVersionUID = -8045773409890719666L;
    private String inputLabel;
    private String weightLabel;

    public AbstractClusterer() {
        this("Input", "Weight");
    }

    public AbstractClusterer(String inputLabel, String weightLabel) {
        this.inputLabel = inputLabel;
        this.weightLabel = weightLabel;
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public void setInputLabel(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    public String getWeightLabel() {
        return this.weightLabel;
    }

    public void setWeightLabel(String weightLabel) {
        this.weightLabel = weightLabel;
    }

    @Override
    public void predict(ListDataSet dataSet) throws Exception {
        for (Sample sample : dataSet) {
            this.predict(sample);
        }
    }

    @Override
    public final void predict(Sample sample) throws Exception {
        Matrix output = this.predict(sample.getAsMatrix(this.getInputLabel()), sample.getAsMatrix(this.getWeightLabel()));
        sample.put("Predicted", output);
    }
}

