/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.GUIObject;

public class Show
extends AbstractAlgorithm {
    private static final long serialVersionUID = -5552405417194118742L;
    public static final String DESCRIPTION = "shows an Object in a JFrame";

    public Show(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object o = input.get("Source");
        Object ret = null;
        if (o instanceof CoreObject) {
            ret = ((CoreObject)o).showGUI();
        } else if (o instanceof GUIObject) {
            ret = ((GUIObject)o).showGUI();
        } else if (o instanceof Matrix) {
            ret = ((Matrix)o).showGUI();
        } else if (o instanceof JFrame) {
            ((JFrame)o).setVisible(true);
            ret = o;
        } else if (o instanceof Container) {
            JFrame frame = new JFrame();
            frame.setSize(1024, 768);
            frame.setContentPane((Container)o);
            frame.setVisible(true);
        }
        result.put("Target", ret);
        return result;
    }
}

