/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class LogisticFunction
extends AbstractAlgorithm {
    private static final long serialVersionUID = -6185025728766094423L;
    public static final String DESCRIPTION = "target = 1/(exp(-x)+1)";

    public LogisticFunction(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix in = MathUtil.getMatrix(input.get("Source"));
        result.put("Target", new org.ujmp.core.doublematrix.calculation.entrywise.misc.LogisticFunction(in).calcNew());
        return result;
    }

    public void setSourceVariable(Variable source) {
        this.setVariable("Source", source);
    }

    public void setTargetVariable(Variable target) {
        this.setVariable("Target", target);
    }
}

