/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.util.StringUtil;

public class Import
extends AbstractAlgorithm {
    private static final long serialVersionUID = -8530782654162802033L;
    public static final String DESCRIPTION = "import a matrix from file";
    private FileFormat defaultFormat = FileFormat.CSV;
    public static final String FORMAT = "Format";

    public Import(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey(FORMAT);
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Filename");
        this.setEdgeLabel(FORMAT, FORMAT);
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(FORMAT, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        try {
            FileFormat format = this.defaultFormat;
            HashMap<String, Object> result = new HashMap<String, Object>();
            String file = StringUtil.format(input.get("Source"));
            Object o2 = input.get(FORMAT);
            if (o2 != null) {
                format = FileFormat.valueOf(StringUtil.format(o2));
            }
            Matrix target = Matrix.Factory.importFrom().file(file).asDenseCSV();
            result.put("Target", target);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

